/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.PropertyException;
import org.webmacro.Provider;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.broker.ContextAutoLoader;
import org.webmacro.engine.DefaultEvaluationExceptionHandler;
import org.webmacro.engine.EvaluationExceptionHandler;
import org.webmacro.engine.IntrospectionUtils;
import org.webmacro.engine.MethodWrapper;
import org.webmacro.engine.PropertyOperatorCache;
import org.webmacro.engine.StringTemplate;
import org.webmacro.util.LogFile;
import org.webmacro.util.LogSystem;
import org.webmacro.util.LogTarget;
import org.webmacro.util.LogTargetFactory;
import org.webmacro.util.Settings;
import org.webmacro.util.SubSettings;

public class Broker {
    public static final String WEBMACRO_DEFAULTS = "WebMacro.defaults";
    public static final String WEBMACRO_PROPERTIES = "WebMacro.properties";
    public static final String SETTINGS_PREFIX = "org.webmacro";
    public static final WeakHashMap BROKERS = new WeakHashMap();
    private static Settings _defaultSettings;
    protected static ClassLoader _myClassLoader;
    protected static ClassLoader _systemClassLoader;
    protected final Hashtable _providers = new Hashtable();
    protected final Settings _config = new Settings();
    protected final String _name;
    protected final LogSystem _ls;
    public final PropertyOperatorCache _propertyOperators = new PropertyOperatorCache();
    protected Log _log;
    private EvaluationExceptionHandler _eeHandler;
    private Map _brokerLocal = new ConcurrentHashMap();
    private Map _functionMap = new ConcurrentHashMap();
    private Map _toolLoader = new ConcurrentHashMap();
    private Map _macros = new ConcurrentHashMap();

    protected Broker() throws InitException {
        this(null, WEBMACRO_PROPERTIES);
        String propertySource = "WebMacro.defaults, WebMacro.properties, (System Properties)";
        this.loadDefaultSettings();
        this.loadSettings(WEBMACRO_PROPERTIES, true);
        this.loadSystemSettings();
        this.initLog();
        this._log.notice("Loaded settings from " + propertySource);
        this.init();
    }

    protected Broker(Properties props) throws InitException {
        this(null, "Ad-hoc Properties " + props.hashCode());
        String propertySource = "WebMacro.defaults, WebMacro.properties, (caller-supplied Properties), (System Properties)";
        this.loadDefaultSettings();
        this.loadSettings(WEBMACRO_PROPERTIES, true);
        this.loadSettings(props);
        this.loadSystemSettings();
        this.initLog();
        this._log.notice("Loaded settings from " + propertySource);
        this.init();
    }

    protected Broker(String fileName) throws InitException {
        this(null, fileName);
        String propertySource = "WebMacro.defaults, " + fileName;
        this.loadDefaultSettings();
        boolean loaded = this.loadSettings(fileName, false);
        if (!loaded) {
            propertySource = propertySource + "(not found)";
        }
        this.loadSystemSettings();
        propertySource = propertySource + ", (System Properties)";
        this.initLog();
        this._log.notice("Loaded settings from " + propertySource);
        this.init();
    }

    protected Broker(Broker dummy, String name) throws InitException {
        this._name = name;
        this._ls = new LogSystem(this._name);
        this._log = this._ls.getLog("broker", "general object loader and configuration");
    }

    protected void initLog() {
        final LogTargetFactory ltf = LogTargetFactory.getInstance();
        final Broker broker = this;
        if (!this._config.containsKey("LogTargets")) {
            try {
                this._ls.addTarget(new LogFile(this._config));
            }
            catch (IOException e) {
                this._log.error("Failed to open logfile", e);
            }
        } else {
            this._config.processListSetting("LogTargets", new Settings.ListSettingHandler(){

                public void processSetting(String settingKey, String settingValue) {
                    try {
                        LogTarget lt = ltf.createLogTarget(broker, settingValue, Broker.this._config);
                        Broker.this._ls.addTarget(lt);
                    }
                    catch (LogTargetFactory.LogCreationException e) {
                        Broker.this._log.error("Broker unable to init log " + settingValue, e);
                    }
                }
            });
        }
        this._log.notice("starting " + this.getClass().getName() + ": " + this._name);
    }

    public Log getBrokerLog() {
        return this._log;
    }

    protected void init() throws InitException {
        this._propertyOperators.init(this, this._config);
        if (this._log.loggingDebug()) {
            Object[] properties = this._config.getKeys();
            Arrays.sort(properties);
            for (int i = 0; i < properties.length; ++i) {
                this._log.debug("Property " + (String)properties[i] + ": " + this._config.getSetting((String)properties[i]));
            }
        }
        this._config.processListSetting("Providers", new ProviderSettingHandler());
        if (this._providers.size() == 0) {
            this._log.error("No Providers specified");
            throw new InitException("No Providers specified in configuration");
        }
        this._config.processListSetting("ContextAutoLoaders", new AutoLoaderSettingHandler());
        String eehClass = this._config.getSetting("ExceptionHandler");
        if (eehClass != null && !eehClass.equals("")) {
            try {
                this._eeHandler = (EvaluationExceptionHandler)this.classForName(eehClass).newInstance();
            }
            catch (Exception e) {
                this._log.warning("Unable to instantiate exception handler of class " + eehClass + "; " + e);
            }
        }
        if (this._eeHandler == null) {
            this._eeHandler = new DefaultEvaluationExceptionHandler();
        }
        this._eeHandler.init(this, this._config);
        SubSettings fnSettings = new SubSettings(this._config, "Functions");
        String[] fns = fnSettings.getKeys();
        for (int i = 0; fns != null && i < fns.length; ++i) {
            String argString;
            String fn = fns[i];
            String fnSetting = fnSettings.getSetting(fn);
            int lastDot = fnSetting.lastIndexOf(46);
            if (lastDot == -1) {
                throw new IllegalArgumentException("Bad function declaration for " + fn + ": " + fnSetting + ".  This setting must include full class name followed by a '.' and method name");
            }
            String fnClassName = fnSetting.substring(0, lastDot);
            String fnMethName = fnSetting.substring(lastDot + 1);
            String fnType = this._config.getSetting("Function." + fn + ".type", "static");
            Object[] args = null;
            if ("factory".equals(fnType)) {
                // empty if block
            }
            if (!"static".equals(fnType) && (argString = this._config.getSetting("Function." + fn + ".args")) != null) {
                if (!argString.startsWith("[")) {
                    argString = "[" + argString + "]";
                }
                StringTemplate tmpl = new StringTemplate(this, "#set $args=" + argString);
                Context argContext = new Context(this);
                try {
                    tmpl.evaluateAsString(argContext);
                }
                catch (Exception e) {
                    this._log.error("Unable to evaluate arguments to function " + fn + ".  The specified string was " + argString + ".", e);
                }
                args = (Object[])argContext.get("args");
                this._log.debug("Args for function " + fn + ": " + Arrays.asList(args));
            }
            Class<?> c = null;
            try {
                c = Class.forName(fnClassName);
            }
            catch (Exception e) {
                this._log.error("Unable to load class " + fnClassName + " for function " + fn, e);
            }
            Object o = c;
            try {
                if (c != null && "instance".equals(fnType)) {
                    o = IntrospectionUtils.instantiate(c, args);
                }
                MethodWrapper mw = new MethodWrapper(o, fnMethName);
                this._functionMap.put(fn, mw);
                continue;
            }
            catch (Exception e) {
                this._log.error("Unable to instantiate the function " + fn + " using the supplied configuration.", e);
            }
        }
        MacroIncludeSettingHandler macroHandler = new MacroIncludeSettingHandler();
        this._config.processListSetting("Macros.Include", macroHandler);
        if (macroHandler.e != null) {
            throw new InitException("Error loading one or more macro libraries", macroHandler.e);
        }
    }

    public static Broker getBroker() throws InitException {
        try {
            Broker b = Broker.findBroker(WEBMACRO_PROPERTIES);
            if (b == null) {
                b = new Broker();
                Broker.register(WEBMACRO_PROPERTIES, b);
            }
            return b;
        }
        catch (InitException e) {
            Log log = LogSystem.getSystemLog("wm");
            log.error("Failed to initialize WebMacro with default config");
            throw e;
        }
    }

    public static Broker getBroker(Properties p) throws InitException {
        try {
            Broker b = Broker.findBroker(p);
            if (b == null) {
                b = new Broker(p);
                Broker.register(p, b);
            }
            return b;
        }
        catch (InitException e) {
            Log log = LogSystem.getSystemLog("wm");
            log.error("Failed to initialize WebMacro with default config");
            throw e;
        }
    }

    public static Broker getBroker(String settingsFile) throws InitException {
        try {
            Broker b = Broker.findBroker(settingsFile);
            if (b == null) {
                b = new Broker(settingsFile);
                Broker.register(settingsFile, b);
            }
            return b;
        }
        catch (InitException e) {
            Log log = LogSystem.getSystemLog("wm");
            log.error("Failed to initialize WebMacro from " + settingsFile);
            throw e;
        }
    }

    protected synchronized void loadDefaultSettings() throws InitException {
        if (_defaultSettings == null) {
            try {
                _defaultSettings = new Settings(WEBMACRO_DEFAULTS);
            }
            catch (IOException e) {
                throw new InitException("IO Error reading WebMacro.defaults", e);
            }
        }
        this._config.load(_defaultSettings);
    }

    protected boolean loadSettings(String name, boolean optional) throws InitException {
        URL u = this.getResource(name);
        if (u != null) {
            try {
                this._config.load(u);
                return true;
            }
            catch (IOException e) {
                if (optional) {
                    this._log.notice("Cannot find properties file " + name + ", continuing");
                }
                e.printStackTrace();
                if (!optional) {
                    throw new InitException("Error reading settings from " + name, e);
                }
            }
        } else if (!optional) {
            throw new InitException("Error reading settings from " + name);
        }
        return false;
    }

    protected void loadSettings(Properties p) {
        this._config.load(p);
    }

    protected void loadSystemSettings() {
        this._config.load(System.getProperties(), SETTINGS_PREFIX);
    }

    protected static void register(Object key, Broker broker) {
        BROKERS.put(key, new WeakReference<Broker>(broker));
    }

    protected static Broker findBroker(Object key) {
        WeakReference ref = (WeakReference)BROKERS.get(key);
        if (ref != null) {
            Broker broker = (Broker)ref.get();
            if (broker == null) {
                BROKERS.remove(key);
            }
            return broker;
        }
        return null;
    }

    public Settings getSettings() {
        return this._config;
    }

    public String getSetting(String key) {
        return this._config.getSetting(key);
    }

    public boolean getBooleanSetting(String key) {
        return this._config.getBooleanSetting(key);
    }

    public int getIntegerSetting(String key) {
        return this._config.getIntegerSetting(key);
    }

    public int getIntegerSetting(String key, int defaultValue) {
        return this._config.getIntegerSetting(key, defaultValue);
    }

    public void addProvider(Provider p, String pType) throws InitException {
        if (pType == null || pType.equals("")) {
            pType = p.getType();
        }
        p.init(this, this._config);
        this._providers.put(pType, p);
        this._log.info("Loaded provider " + p);
        if (!pType.equals(p.getType())) {
            this._log.info("Provider name remapped from " + p.getType() + " to " + pType);
        }
    }

    public Provider getProvider(String type) throws NotFoundException {
        Provider p = (Provider)this._providers.get(type);
        if (p == null) {
            throw new NotFoundException("No provider for type " + type + ": perhaps WebMacro couldn't load its configuration?");
        }
        return p;
    }

    public Iterator getProviderTypes() {
        return this._providers.keySet().iterator();
    }

    public void destroy() {
        Iterator providers = this._providers.values().iterator();
        while (providers.hasNext()) {
            ((Provider)providers.next()).destroy();
        }
    }

    public Log getLog(String type, String description) {
        return this._ls.getLog(type, description);
    }

    public Log getLog(String type) {
        return this._ls.getLog(type, type);
    }

    public final FastWriter getFastWriter(OutputStream out, String enctype) throws UnsupportedEncodingException {
        return FastWriter.getInstance(this, out, enctype);
    }

    public EvaluationExceptionHandler getEvaluationExceptionHandler() {
        return this._eeHandler;
    }

    public void setEvaluationExceptionHandler(EvaluationExceptionHandler eeh) {
        this._eeHandler = eeh;
    }

    public Map getMacros() {
        return this._macros;
    }

    public URL getResource(String name) {
        URL u = _myClassLoader.getResource(name);
        if (u == null) {
            u = _systemClassLoader.getResource(name);
        }
        if (u == null) {
            try {
                u = new URL("file", null, -1, name);
                File f = new File(u.getFile());
                if (!f.exists()) {
                    u = null;
                }
            }
            catch (MalformedURLException ignored) {
                this._log.error("MalformedURL", ignored);
            }
        }
        return u;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = _myClassLoader.getResourceAsStream(name);
        if (is == null) {
            is = _systemClassLoader.getResourceAsStream(name);
        }
        if (is == null) {
            try {
                is = new FileInputStream(name);
            }
            catch (FileNotFoundException ignored) {
                this._log.error("FileNotFound", ignored);
            }
        }
        return is;
    }

    public URL getTemplate(String name) {
        return this.getResource(name);
    }

    public Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public Object get(String type, String query) throws ResourceException {
        return this.getProvider(type).get(query);
    }

    public void setBrokerLocal(Object key, Object value) {
        this._brokerLocal.put(key, value);
    }

    public Object getBrokerLocal(Object key) {
        return this._brokerLocal.get(key);
    }

    public MethodWrapper getFunction(String fnName) {
        return (MethodWrapper)this._functionMap.get(fnName);
    }

    public void putFunction(String fnName, MethodWrapper mw) {
        this._functionMap.put(fnName, mw);
    }

    public void putFunction(String fnName, Object instance, String methodName) {
        MethodWrapper func = new MethodWrapper(instance, methodName);
        this.putFunction(fnName, func);
    }

    public Object getAutoContextVariable(String variableName, Context context) {
        ContextAutoLoader loader = (ContextAutoLoader)this._toolLoader.get(variableName);
        try {
            if (loader == null) {
                return null;
            }
            return loader.get(variableName, context);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void registerAutoContextVariable(String variableName, ContextAutoLoader loader) {
        this._toolLoader.put(variableName, loader);
    }

    public final Object getValue(String type, String query) throws ResourceException {
        return this.get(type, query);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Broker:");
        buf.append(this._name);
        buf.append("(");
        Enumeration e = this._providers.elements();
        while (e.hasMoreElements()) {
            Provider pr = (Provider)e.nextElement();
            buf.append(pr);
            if (!e.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String getName() {
        return this._name;
    }

    public ClassLoader getClassLoader() {
        return _myClassLoader;
    }

    public static void main(String[] arg) {
        try {
            String line;
            if (arg.length != 1) {
                System.out.println("Arg required: config file URL");
                System.out.println("Then input is: TYPE NAME lines on stdin");
                System.exit(1);
            }
            Broker broker = new Broker(arg[0]);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                int space = line.indexOf(32);
                String type = line.substring(0, space);
                String name = line.substring(space + 1);
                System.out.println("broker.get(\"" + type + "\", \"" + name + "\"):");
                Object o = broker.get(type, name);
                System.out.println("RESULT:");
                System.out.println(o.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        _myClassLoader = Broker.class.getClassLoader();
        _systemClassLoader = ClassLoader.getSystemClassLoader();
    }

    private class MacroIncludeSettingHandler
    extends Settings.ListSettingHandler {
        Exception e;

        private MacroIncludeSettingHandler() {
        }

        public void processSetting(String settingKey, String settingValue) {
            block2: {
                try {
                    Template t = (Template)Broker.this.getProvider("template").get(settingValue);
                    Broker.this._macros.putAll(t.getMacros());
                }
                catch (ResourceException e) {
                    Broker.this._log.error("Error loading macro library '" + settingValue + "', ignoring it", e);
                    if (this.e != null) break block2;
                    this.e = e;
                }
            }
        }
    }

    private class AutoLoaderSettingHandler
    extends Settings.ListSettingHandler {
        private AutoLoaderSettingHandler() {
        }

        public void processSetting(String settingKey, String settingValue) {
            try {
                Class pClass = Broker.this.classForName(settingValue);
                ContextAutoLoader instance = (ContextAutoLoader)pClass.newInstance();
                instance.init(Broker.this, settingKey);
            }
            catch (Exception e) {
                Broker.this._log.error("ContextAutoLoader (" + settingValue + ") failed to load", e);
            }
        }
    }

    private class ProviderSettingHandler
    extends Settings.ListSettingHandler {
        private ProviderSettingHandler() {
        }

        public void processSetting(String settingKey, String settingValue) {
            try {
                Class pClass = Broker.this.classForName(settingValue);
                Provider instance = (Provider)pClass.newInstance();
                Broker.this.addProvider(instance, settingKey);
            }
            catch (Exception e) {
                Broker.this._log.error("Provider (" + settingValue + ") failed to load", e);
            }
        }
    }
}

