/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.webmacro.Broker;
import org.webmacro.ResourceException;
import org.webmacro.util.ByteBufferOutputStream;
import org.webmacro.util.Encoder;

public class FastWriter
extends Writer {
    public static final String SAFE_UNICODE_ENCODING;
    private final int DEFAULT_BUFFER_SIZE;
    private final String _encoding;
    private final Writer _bwriter;
    private final ByteBufferOutputStream _bstream;
    private final Encoder _encoder;
    private OutputStream _out;
    private char[] _cbuf = new char[512];
    private boolean _buffered;

    public FastWriter(Broker broker, OutputStream out, String encoding) throws UnsupportedEncodingException {
        this.DEFAULT_BUFFER_SIZE = broker.getSettings().getIntegerSetting("FastWriter.DefaultBufferSize", 4096);
        this._encoding = FastWriter.hackEncoding(encoding);
        this._bstream = new ByteBufferOutputStream(this.DEFAULT_BUFFER_SIZE);
        this._bwriter = new OutputStreamWriter((OutputStream)this._bstream, this._encoding);
        try {
            this._encoder = (Encoder)broker.get("encoder", this._encoding);
        }
        catch (ResourceException re) {
            throw new UnsupportedEncodingException(re.getMessage());
        }
        this._buffered = false;
        this._out = out;
    }

    private static String hackEncoding(String encoding) {
        if (encoding.toLowerCase().startsWith("cp") && !encoding.startsWith("Cp")) {
            encoding = "Cp".concat(encoding.substring(2));
        }
        return encoding;
    }

    public FastWriter(Broker broker, String encoding) throws UnsupportedEncodingException {
        this(broker, null, encoding);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Encoder getEncoder() {
        return this._encoder;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void write(char[] cbuf) throws IOException {
        this._bwriter.write(cbuf, 0, cbuf.length);
        this._buffered = true;
    }

    public void write(char[] cbuf, int offset, int len) throws IOException {
        this._bwriter.write(cbuf, offset, len);
        this._buffered = true;
    }

    public void write(int c) throws IOException {
        this._bwriter.write(c);
        this._buffered = true;
    }

    public void write(String s) throws IOException {
        int len = s.length();
        try {
            s.getChars(0, len, this._cbuf, 0);
        }
        catch (IndexOutOfBoundsException e) {
            this._cbuf = new char[len + (len - this._cbuf.length)];
            s.getChars(0, len, this._cbuf, 0);
        }
        this._bwriter.write(this._cbuf, 0, len);
        this._buffered = true;
    }

    public void write(String s, int off, int len) throws IOException {
        try {
            s.getChars(off, off + len, this._cbuf, 0);
        }
        catch (IndexOutOfBoundsException e) {
            this._cbuf = new char[len + (len - this._cbuf.length)];
            s.getChars(off, off + len, this._cbuf, 0);
        }
        this._bwriter.write(this._cbuf, 0, len);
        this._buffered = true;
    }

    public void writeStatic(String s) {
        if (this._buffered) {
            this.bflush();
        }
        try {
            byte[] b = this._encoder.encode(s);
            this._bstream.write(b, 0, b.length);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
    }

    public void write(byte[] rawBytes) {
        if (this._buffered) {
            this.bflush();
        }
        this._bstream.write(rawBytes);
    }

    public void write(byte[] rawBytes, int offset, int len) {
        if (this._buffered) {
            this.bflush();
        }
        this._bstream.write(rawBytes, offset, len);
    }

    private void bflush() {
        try {
            this._bwriter.flush();
            this._buffered = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() throws IOException {
        if (this._buffered) {
            this.bflush();
        }
        if (this._out != null) {
            this.writeTo(this._out);
            this._out.flush();
        }
        this._bstream.reset();
    }

    public int size() throws IOException {
        if (this._buffered) {
            this.bflush();
        }
        return this._bstream.size();
    }

    public byte[] toByteArray() {
        if (this._buffered) {
            this.bflush();
        }
        return this._bstream.getBytes();
    }

    public String toString() {
        if (this._buffered) {
            this.bflush();
        }
        try {
            return this._bstream.toString(this._encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this._buffered) {
            this.bflush();
        }
        this._bstream.writeTo(out);
    }

    public void reset(OutputStream out) {
        if (this._buffered) {
            this.bflush();
        }
        this._bstream.reset();
        this._out = out;
    }

    public static FastWriter getInstance(Broker broker, OutputStream out, String encoding) throws UnsupportedEncodingException {
        return new FastWriter(broker, out, encoding);
    }

    public static FastWriter getInstance(Broker broker, OutputStream out) throws UnsupportedEncodingException {
        return FastWriter.getInstance(broker, out, SAFE_UNICODE_ENCODING);
    }

    public static FastWriter getInstance(Broker broker, String encoding) throws UnsupportedEncodingException {
        return FastWriter.getInstance(broker, null, encoding);
    }

    public static FastWriter getInstance(Broker broker) {
        try {
            return FastWriter.getInstance(broker, null, SAFE_UNICODE_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this._out != null) {
            this._out.close();
            this._out = null;
        }
    }

    static {
        String encoding = "UTF16-BE";
        try {
            encoding.getBytes(encoding);
        }
        catch (Exception e) {
            encoding = "UTF8";
        }
        SAFE_UNICODE_ENCODING = encoding;
    }
}

