/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.io.PrintStream;
import java.io.PrintWriter;

public class RethrowableException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Throwable cause;
    private static final String RETHROW_MESSAGE = "-- secondary stack trace --";

    public RethrowableException() {
    }

    public RethrowableException(String s) {
        super(s);
    }

    public RethrowableException(String s, Throwable e) {
        super(s + System.getProperty("line.separator") + e);
        this.cause = e;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            System.err.println(RETHROW_MESSAGE);
            this.cause.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.cause != null) {
            ps.println(RETHROW_MESSAGE);
            this.cause.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.cause != null) {
            pw.println(RETHROW_MESSAGE);
            this.cause.printStackTrace(pw);
        }
    }

    public Throwable getCaught() {
        return this.getCause();
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Throwable getRootCause() {
        Throwable t = this.cause;
        while (t != null && t instanceof RethrowableException) {
            t = ((RethrowableException)t).cause;
        }
        return t;
    }
}

