/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.PropertyException;
import org.webmacro.Provider;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.WebMacro;
import org.webmacro.servlet.ServletBroker;
import org.webmacro.servlet.WebContext;

public class WM
implements WebMacro {
    private final Broker _broker;
    private final Provider _tmplProvider;
    private final Provider _urlProvider;
    private final Log _log;

    public WM() throws InitException {
        this(Broker.getBroker());
    }

    public WM(Properties p) throws InitException {
        this(Broker.getBroker(p));
    }

    public WM(String config) throws InitException {
        this(Broker.getBroker(config));
    }

    public WM(Servlet s) throws InitException {
        this(ServletBroker.getBroker(s));
    }

    public WM(Servlet s, Properties additionalProperties) throws InitException {
        this(ServletBroker.getBroker(s, additionalProperties));
    }

    public WM(ServletContext sc, ClassLoader cl, Properties additionalProperties) throws InitException {
        this(ServletBroker.getBroker(sc, cl, additionalProperties));
    }

    public WM(Broker broker) throws InitException {
        if (broker == null) {
            throw new InitException("No Broker passed to WM()");
        }
        this._broker = broker;
        this._log = this._broker.getLog("wm", "WebMacro instance lifecycle");
        this._log.notice("new " + this + " v" + "@VERSION@");
        try {
            this._tmplProvider = this._broker.getProvider("template");
            this._urlProvider = this._broker.getProvider("url");
        }
        catch (NotFoundException nfe) {
            this._log.error("Could not load configuration", nfe);
            throw new InitException("Could not locate provider; This implies that WebMacro is badly misconfigured, you\nshould double check that all configuration files and\noptions are set up correctly. In a default install of\nWebMacro this likely means your WebMacro.properties file\nwas not found on your CLASSPATH.", nfe);
        }
    }

    public String toString() {
        return "WebMacro(" + this._broker.getName() + ")";
    }

    public final Broker getBroker() {
        return this._broker;
    }

    public final FastWriter getFastWriter(OutputStream out, String enctype) throws UnsupportedEncodingException {
        return FastWriter.getInstance(this._broker, out, enctype);
    }

    public final Context getContext() {
        return new Context(this._broker);
    }

    public final WebContext getWebContext(HttpServletRequest req, HttpServletResponse resp) {
        return new WebContext(this._broker, req, resp);
    }

    public final Template getTemplate(String key) throws ResourceException {
        return (Template)this._tmplProvider.get(key);
    }

    public final String getURL(String url) throws ResourceException {
        return (String)this._urlProvider.get(url);
    }

    public final String getConfig(String key) throws NotFoundException {
        try {
            return (String)this._broker.get("config", key);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (ResourceException e) {
            throw new NotFoundException(e.toString(), e);
        }
    }

    public final Log getLog(String type, String description) {
        return this._broker.getLog(type, description);
    }

    public final Log getLog(String type) {
        return this._broker.getLog(type, type);
    }

    public final void writeTemplate(String templateName, OutputStream out, Context context) throws IOException, ResourceException, PropertyException {
        this.writeTemplate(templateName, out, this.getConfig("TemplateOutputEncoding"), context);
    }

    public final void writeTemplate(String templateName, OutputStream out, String encoding, Context context) throws IOException, ResourceException, PropertyException {
        if (encoding == null) {
            encoding = this.getConfig("TemplateOutputEncoding");
        }
        Template tmpl = this.getTemplate(templateName);
        tmpl.write(out, encoding, context);
    }

    public static void main(String[] args) {
        System.out.println("WebMacro v@VERSION@.  Built @BUILD_DATE@");
    }

    public void destroy() {
        this.getBroker().destroy();
    }
}

