/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import java.util.Iterator;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.directive.IteratorAlternator;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Variable;

public class AlternateDirective
extends Directive {
    private static final int ALTERNATE_TARGET = 1;
    private static final int ALTERNATE_THROUGH = 2;
    private static final int ALTERNATE_LIST = 3;
    private Variable target;
    private Object list;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.KeywordArg(2, "through"), new Directive.RValueArg(3)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("alternate", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this.target = (Variable)builder.getArg(1, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(AlternateDirective.myDescr.name, e);
        }
        this.list = builder.getArg(3, bc);
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        Object l = null;
        try {
            l = this.list instanceof Macro ? ((Macro)this.list).evaluate(context) : this.list;
            Iterator itr = context.getBroker()._propertyOperators.getIterator(l);
            this.target.setValue(context, new IteratorAlternator(itr));
        }
        catch (Exception e) {
            String warning = "#alternate: list argument is not a list: " + l;
            AlternateDirective.writeWarning(warning, context, out);
            return;
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(AlternateDirective.myDescr.name);
        v.visitDirectiveArg("AlternateTarget", this.target);
        v.visitDirectiveArg("AlternateList", this.list);
        v.endDirective();
    }
}

