/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Variable;

public class DefaultDirective
extends Directive {
    private static final int DEFAULT_TARGET = 1;
    private static final int DEFAULT_RESULT = 3;
    private Variable target;
    private Object result;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.OptionalGroup(2), new Directive.AssignmentArg(), new Directive.RValueArg(3)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("default", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this.target = (Variable)builder.getArg(1, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(DefaultDirective.myDescr.name, e);
        }
        if (!this.target.isSimpleName()) {
            throw new Directive.NotSimpleVariableBuildException(DefaultDirective.myDescr.name);
        }
        this.result = builder.getArg(3, bc);
        if (this.result == null) {
            this.result = "";
        }
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        try {
            if (context.containsKey(this.target.getName())) {
                return;
            }
            if (this.result instanceof Macro) {
                this.target.setValue(context, ((Macro)this.result).evaluate(context));
            } else {
                this.target.setValue(context, this.result);
            }
        }
        catch (PropertyException e) {
            throw e;
        }
        catch (Exception e) {
            String errorText = "#default: Unable to set default value for " + this.target;
            DefaultDirective.writeWarning(errorText, context, out);
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(DefaultDirective.myDescr.name);
        v.visitDirectiveArg("DefaultTarget", this.target);
        v.visitDirectiveArg("DefaultValue", this.result);
        v.endDirective();
    }
}

