/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.util.Vector;
import org.webmacro.directive.ArgsHolder;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveArgs;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;

public final class DirectiveBuilder
implements Builder,
DirectiveArgs {
    private final DirectiveDescriptor desc;
    private ArgsHolder buildArgs;
    private Object[] subdirectives;
    private static final ArgsHolder[] aha = new ArgsHolder[0];
    private static final String EXC_GETSUBD_NOTREPEATING = "getSubdirective: attempt to get repeating subdirective -- use getRepeatingSubdirective() instead";
    private static final String EXC_GETSUBD_REPEATING = "getRepeatingSubdirective: attempt to get nonrepeating subdirective -- use getSubdirective() instead";

    public DirectiveBuilder(DirectiveDescriptor desc) {
        this.desc = desc;
        if (desc.args != null && desc.args.length > 0) {
            this.buildArgs = new ArgsHolder(desc.args);
        }
        if (desc.subdirectives != null && desc.subdirectives.length > 0) {
            this.subdirectives = new Object[desc.subdirectives.length];
        }
    }

    private int findSubdirectiveIndex(int id) throws BuildException {
        for (int i = 0; i < this.desc.subdirectives.length; ++i) {
            if (this.desc.subdirectives[i].id != id) continue;
            return i;
        }
        throw new BuildException("Invalid argument ID " + id + " requested for directive " + this.desc.name);
    }

    public Object getExactArg(int idx) throws BuildException {
        if (this.buildArgs == null) {
            return null;
        }
        return this.buildArgs.getExactArg(idx);
    }

    public int getArgCount() {
        if (this.buildArgs == null) {
            return 0;
        }
        return this.buildArgs.getArgCount();
    }

    public Object getArg(int argId) throws BuildException {
        if (this.buildArgs == null) {
            return null;
        }
        return this.buildArgs.getArg(argId);
    }

    public Object getArg(int argId, BuildContext bc) throws BuildException {
        if (this.buildArgs == null) {
            return null;
        }
        return this.buildArgs.getArg(argId, bc);
    }

    public int getSubdirectiveCount(int subdId) throws BuildException {
        int i = this.findSubdirectiveIndex(subdId);
        if (this.subdirectives[i] == null) {
            return 0;
        }
        return this.desc.subdirectives[i].repeating ? ((ArgsHolder[])this.subdirectives[i]).length : 1;
    }

    public void setArg(int argId, Object arg) throws BuildException {
        this.buildArgs.setArg(argId, arg);
    }

    public DirectiveArgs newSubdirective(int subdId) throws BuildException {
        ArgsHolder ah = null;
        int index = this.findSubdirectiveIndex(subdId);
        if (!this.desc.subdirectives[index].repeating) {
            if (this.subdirectives[index] == null) {
                this.subdirectives[index] = new ArgsHolder(this.desc.subdirectives[index].args);
            }
            ah = (ArgsHolder)this.subdirectives[index];
        } else {
            if (this.subdirectives[index] == null) {
                this.subdirectives[index] = new Vector();
            }
            Vector v = (Vector)this.subdirectives[index];
            ah = new ArgsHolder(this.desc.subdirectives[index].args);
            v.addElement(ah);
        }
        return ah;
    }

    public boolean subdirectiveOk(int subdId) throws BuildException {
        int index = this.findSubdirectiveIndex(subdId);
        return this.desc.subdirectives[index].repeating || this.subdirectives[index] == null;
    }

    public ArgsHolder getSubdirective(int subdId) throws BuildException {
        int index = this.findSubdirectiveIndex(subdId);
        if (this.desc.subdirectives[index].repeating) {
            throw new BuildException(EXC_GETSUBD_NOTREPEATING);
        }
        return (ArgsHolder)this.subdirectives[index];
    }

    public ArgsHolder[] getRepeatingSubdirective(int subdId) throws BuildException {
        int index = this.findSubdirectiveIndex(subdId);
        if (!this.desc.subdirectives[index].repeating) {
            throw new BuildException(EXC_GETSUBD_REPEATING);
        }
        if (this.subdirectives[index] == null) {
            return null;
        }
        return ((Vector)this.subdirectives[index]).toArray(aha);
    }

    public Object build(BuildContext bc) throws BuildException {
        Directive d;
        try {
            d = (Directive)this.desc.dirClass.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Error instantiating Directive object for #" + this.desc.name);
        }
        return d.build(this, bc);
    }

    public String getName() {
        return this.desc.name;
    }
}

