/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import java.util.Map;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.StringMacro;
import org.webmacro.engine.Variable;

public class EvalDirective
extends Directive {
    private static final int EVAL_EXPR = 1;
    private static final int EVAL_USING = 2;
    private static final int EVAL_MAP = 3;
    private static final int MAX_RECURSION_DEPTH = 100;
    private Object _evalTarget;
    private Object _mapExpr = null;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.RValueArg(1), new Directive.OptionalGroup(2), new Directive.KeywordArg(2, "using"), new Directive.RValueArg(3)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("eval", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        this._evalTarget = builder.getArg(1, bc);
        if (builder.getArg(2) != null) {
            this._mapExpr = builder.getArg(3, bc);
        }
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        block17: {
            try {
                Macro macro = null;
                Object targ = this._evalTarget;
                if (targ instanceof Variable) {
                    targ = ((Variable)this._evalTarget).getValue(context);
                }
                if (targ instanceof String) {
                    targ = new StringMacro((String)targ);
                }
                if (!(targ instanceof Macro)) {
                    throw new PropertyException("Invalid argument to #eval directive.  First arg must be a Macro or a String.");
                }
                macro = (Macro)targ;
                if (this._mapExpr == null) {
                    macro.write(out, context);
                    break block17;
                }
                Object argmap = this._mapExpr;
                if (argmap instanceof Macro) {
                    argmap = ((Macro)argmap).evaluate(context);
                }
                if (!(argmap instanceof Map)) {
                    throw new PropertyException("The supplied expression did not evaluate to a java.util.Map instance.");
                }
                int recursionDepth = 0;
                if (context.containsKey("EvalDepth")) {
                    try {
                        recursionDepth = (Integer)context.get("EvalDepth");
                        ++recursionDepth;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (recursionDepth > 100) {
                        throw new PropertyException("ERROR: A recursive call to #eval exceeded the maximum depth of 100");
                    }
                }
                Map outerVars = null;
                if (context.containsKey("OuterVars")) {
                    try {
                        outerVars = (Map)context.get("OuterVars");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (outerVars == null) {
                    outerVars = context.getMap();
                }
                Context c = new Context(context.getBroker());
                c.setMap((Map)argmap);
                c.put((Object)"EvalDepth", recursionDepth);
                c.put((Object)"OuterVars", outerVars);
                c.put((Object)"Self", macro);
                macro.write(out, c);
            }
            catch (Exception e) {
                if (e instanceof PropertyException) {
                    throw (PropertyException)e;
                }
                throw new PropertyException("#eval: Unable to evaluate macro.", e);
            }
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(EvalDirective.myDescr.name);
        v.visitDirectiveArg("EvalTarget", this._evalTarget);
        if (this._mapExpr != null) {
            v.visitDirectiveArg("EvalKeyword", "using");
            v.visitDirectiveArg("EvalMap", this._mapExpr);
        }
        v.endDirective();
    }
}

