/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.ArgsHolder;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Expression;

class IfDirective
extends Directive {
    private static final int IF_COND = 1;
    private static final int IF_BLOCK = 2;
    private static final int IF_ELSEIF = 3;
    private static final int IF_ELSE = 4;
    private static final int ELSEIF_COND = 5;
    private static final int ELSEIF_BLOCK = 6;
    private static final int ELSE_BLOCK = 7;
    private int nConditions;
    private Macro[] conditions;
    private Block[] blocks;
    private Block elseBlock;
    private static final Directive.ArgDescriptor[] elseifArgs = new Directive.ArgDescriptor[]{new Directive.ConditionArg(5), new Directive.BlockArg(6)};
    private static final Directive.ArgDescriptor[] elseArgs = new Directive.ArgDescriptor[]{new Directive.BlockArg(7)};
    private static final Directive.ArgDescriptor[] ifArgs = new Directive.ArgDescriptor[]{new Directive.ConditionArg(1), new Directive.BlockArg(2)};
    private static final Directive.Subdirective[] ifSubdirectives = new Directive.Subdirective[]{new Directive.OptionalRepeatingSubdirective(3, "elseif", elseifArgs, 1), new Directive.OptionalSubdirective(4, "else", elseArgs, 1)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("if", null, ifArgs, ifSubdirectives);

    IfDirective() {
    }

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        int elseifCount;
        Object c = builder.getArg(1, bc);
        boolean cMacro = c instanceof Macro;
        ArgsHolder[] elseifArgs = null;
        if (!cMacro && Expression.isTrue(c)) {
            return builder.getArg(2, bc);
        }
        ArgsHolder elseArgs = builder.getSubdirective(4);
        elseifArgs = builder.getRepeatingSubdirective(3);
        int n = elseifCount = elseifArgs == null ? 0 : elseifArgs.length;
        if (elseifArgs == null) {
            if (!cMacro) {
                return elseArgs != null ? elseArgs.getArg(7, bc) : "";
            }
            this.nConditions = 1;
            this.conditions = new Macro[1];
            this.blocks = new Block[1];
            this.conditions[0] = (Macro)c;
            this.blocks[0] = (Block)builder.getArg(2, bc);
            if (elseArgs != null) {
                this.elseBlock = (Block)elseArgs.getArg(7, bc);
            }
            return this;
        }
        int i = 0;
        this.nConditions = elseifCount + (cMacro ? 1 : 0);
        this.conditions = new Macro[this.nConditions];
        this.blocks = new Block[this.nConditions];
        if (cMacro) {
            this.conditions[0] = (Macro)c;
            this.blocks[0] = (Block)builder.getArg(2, bc);
            ++i;
        }
        for (int j = 0; j < elseifCount; ++j) {
            c = elseifArgs[j].getArg(5, bc);
            if (c instanceof Macro) {
                this.conditions[i] = (Macro)c;
                this.blocks[i] = (Block)elseifArgs[j].getArg(6, bc);
                ++i;
                continue;
            }
            if (!Expression.isTrue(c)) continue;
            if (i == 0) {
                return elseifArgs[j].getArg(6, bc);
            }
            this.elseBlock = (Block)elseifArgs[j].getArg(6, bc);
            break;
        }
        if (this.elseBlock == null && elseArgs != null) {
            if (i == 0) {
                return elseArgs.getArg(7, bc);
            }
            this.elseBlock = (Block)elseArgs.getArg(7, bc);
        }
        if (i < this.nConditions) {
            this.nConditions = i;
        }
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        for (int i = 0; i < this.nConditions; ++i) {
            boolean b = false;
            b = Expression.isTrue(this.conditions[i].evaluate(context));
            if (!b) continue;
            this.blocks[i].write(out, context);
            return;
        }
        if (this.elseBlock != null) {
            this.elseBlock.write(out, context);
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(IfDirective.myDescr.name);
        for (int i = 0; i < this.nConditions; ++i) {
            v.visitDirectiveArg(i == 0 ? "IfCondition" : "ElseIfCondition", this.conditions[i]);
            v.visitDirectiveArg(i == 0 ? "IfBlock" : "ElseIfBlock", this.blocks[i]);
        }
        if (this.elseBlock != null) {
            v.visitDirectiveArg("ElseBlock", this.elseBlock);
        }
        v.endDirective();
    }
}

