/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Variable;

public class SetblockDirective
extends Directive {
    private static final int SETBLOCK_AS = 1;
    private static final int SETBLOCK_MACRO = 2;
    private static final int SETBLOCK_TARGET = 3;
    private static final int SETBLOCK_RESULT = 4;
    private Variable target;
    private Object result;
    private boolean asMacro = false;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.OptionalGroup(2), new Directive.KeywordArg(1, "as"), new Directive.KeywordArg(2, "macro"), new Directive.LValueArg(3), new Directive.BlockArg(4)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("setblock", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this.target = (Variable)builder.getArg(3, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(SetblockDirective.myDescr.name, e);
        }
        Object macroKeyword = builder.getArg(2, bc);
        this.asMacro = macroKeyword != null;
        this.result = builder.getArg(4, bc);
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        try {
            if (this.result instanceof Macro && !this.asMacro) {
                this.target.setValue(context, ((Macro)this.result).evaluate(context));
            } else {
                this.target.setValue(context, this.result);
            }
        }
        catch (PropertyException e) {
            throw e;
        }
        catch (Exception e) {
            String errorText = "#setblock: Unable to set " + this.target;
            SetblockDirective.writeWarning(errorText, context, out);
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(SetblockDirective.myDescr.name);
        if (this.asMacro) {
            v.visitDirectiveArg("SetblockKeyword", "as");
            v.visitDirectiveArg("SetblockKeyword", "macro");
        }
        v.visitDirectiveArg("SetblockTarget", this.target);
        v.visitDirectiveArg("SetblockValue", this.result);
        v.endDirective();
    }
}

