/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.WebMacroException;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.StringTemplate;
import org.webmacro.engine.Variable;
import org.webmacro.servlet.TextTool;
import org.webmacro.util.Instantiator;

public class SetpropsDirective
extends Directive {
    private static final String DEFAULT_CLASS_NAME = "java.util.Hashtable";
    private static final int PROPS_TARGET = 1;
    private static final int PROPS_CLASS = 2;
    private static final int PROPS_CLASSNAME = 3;
    private static final int PROPS_RESULT = 4;
    private Variable target;
    private Object result;
    private String _className;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.OptionalGroup(3), new Directive.KeywordArg(2, "class"), new Directive.AssignmentArg(), new Directive.QuotedStringArg(3), new Directive.BlockArg(4)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("setprops", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this.target = (Variable)builder.getArg(1, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(SetpropsDirective.myDescr.name, e);
        }
        this._className = (String)builder.getArg(3, bc);
        if (this._className == null) {
            this._className = DEFAULT_CLASS_NAME;
        }
        this.result = builder.getArg(4, bc);
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        try {
            if (!context.containsKey(this.target.getName())) {
                try {
                    Class c = Instantiator.getInstance(context.getBroker()).classForName(this._className);
                    Object o = c.newInstance();
                    this.target.setValue(context, o);
                }
                catch (RuntimeException re) {
                    throw new PropertyException("Failed to create instance of " + this._className + " for the #properties directive. " + re, re);
                }
            }
            String res = (String)((Macro)this.result).evaluate(context);
            String[] lines = TextTool.getLines(res);
            String prevLine = "";
            String prefix = "#set $" + this.target.getVariableName() + ".";
            for (int i = 0; i < lines.length; ++i) {
                String s = prevLine + lines[i].trim();
                if (s.endsWith("\\")) {
                    prevLine = s.substring(0, s.length() - 1);
                    continue;
                }
                prevLine = "";
                this.setProp(context, s, prefix);
            }
        }
        catch (PropertyException e) {
            throw e;
        }
        catch (Exception e) {
            String errorText = "#setprops: Unable to set " + this.target;
            SetpropsDirective.writeWarning(errorText, context, out);
        }
    }

    private void setProp(Context context, String s, String prefix) throws PropertyException {
        if (s.length() > 0 && !s.startsWith("#")) {
            for (int j = 0; j < s.length(); ++j) {
                char ch = s.charAt(j);
                if (ch != ':' && ch != '=') continue;
                String prop = s.substring(0, j).trim();
                String val = s.substring(j + 1).trim();
                s = prefix + prop + "=\"" + val + "\"";
                try {
                    StringTemplate stmpl = new StringTemplate(context.getBroker(), s);
                    stmpl.evaluateAsString(context);
                }
                catch (WebMacroException wme) {
                    s = prefix + prop + "=" + val;
                    try {
                        StringTemplate stmpl = new StringTemplate(context.getBroker(), s);
                        stmpl.evaluateAsString(context);
                    }
                    catch (WebMacroException wme2) {
                        PropertyException pex = new PropertyException("Failed to set property \"" + prop + "\" to value \"" + val + "\" on variable \"" + this.target.getVariableName() + "\" of type " + this.target.getClass().getName(), wme2);
                        context.getEvaluationExceptionHandler().evaluate(this.target, context, pex);
                    }
                }
                break;
            }
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(SetpropsDirective.myDescr.name);
        v.visitDirectiveArg("PropertiesClassKeyword", "class");
        v.visitDirectiveArg("PropertiesClassName", this._className);
        v.visitDirectiveArg("PropertiesTarget", this.target);
        v.visitDirectiveArg("PropertiesValue", this.result);
        v.endDirective();
    }
}

