/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.util.List;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.Visitable;
import org.webmacro.WebMacroRuntimeException;
import org.webmacro.engine.BlockBuilder;
import org.webmacro.util.Encoder;

public final class Block
implements Macro,
Visitable {
    private final String[] _strings;
    private final Macro[] _macros;
    private final int[] _lineNos;
    private final int[] _colNos;
    private final Encoder.Block _block;
    private final int _length;
    private final int _remainder;
    private String _name;

    protected Block(String name, String[] strings, Macro[] macros, int[] lineNos, int[] colNos) {
        this._name = name;
        this._strings = strings;
        this._macros = macros;
        this._lineNos = lineNos;
        this._colNos = colNos;
        this._length = this._macros.length;
        this._remainder = 10 - this._length % 10;
        this._block = new Encoder.Block(this._strings);
    }

    public final void write(FastWriter out, Context context) throws PropertyException, IOException {
        byte[] b;
        byte[][] bcontent = out.getEncoder().encode(this._block);
        Context.TemplateEvaluationContext teC = context.getTemplateEvaluationContext();
        String oldName = teC._templateName;
        teC._templateName = this._name;
        int i = 0;
        switch (this._remainder) {
            case 1: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 2: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 3: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 4: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 5: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 6: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 7: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 8: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 9: {
                b = bcontent[i];
                out.write(b, 0, b.length);
                teC._lineNo = this.getLineNo(i);
                teC._columnNo = this.getColNo(i);
                this._macros[i++].write(out, context);
            }
            case 10: {
                break;
            }
            default: {
                throw new WebMacroRuntimeException("Bug: _remainder value not 0 to 10: " + this._remainder);
            }
        }
        while (i < this._length) {
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
            b = bcontent[i];
            out.write(b, 0, b.length);
            teC._lineNo = this.getLineNo(i);
            teC._columnNo = this.getColNo(i);
            this._macros[i++].write(out, context);
        }
        b = bcontent[this._length];
        out.write(b, 0, b.length);
        teC._templateName = oldName;
    }

    public String getTemplateName() {
        return this._name;
    }

    public void setTemplateName(String name) {
        this._name = name;
    }

    public int getLineNo(int i) {
        return this._lineNos != null && i >= 0 && this._lineNos.length > i ? this._lineNos[i] : 0;
    }

    public int getColNo(int i) {
        return this._colNos != null && i >= 0 && this._colNos.length > i ? this._colNos[i] : 0;
    }

    public BlockBuilder.BlockIterator getBlockIterator() {
        return new BlockIterator(this._strings, this._macros, this);
    }

    final void appendTo(List l) {
        int len = this._macros.length;
        for (int i = 0; i < this._macros.length; ++i) {
            l.add(this._strings[i]);
            l.add(this._macros[i]);
        }
        l.add(this._strings[len]);
    }

    public final void accept(TemplateVisitor v) {
        v.beginBlock();
        int len = this._macros.length;
        for (int i = 0; i < len; ++i) {
            v.visitString(this._strings[i]);
            v.visitMacro(this._macros[i]);
        }
        v.visitString(this._strings[len]);
        v.endBlock();
    }

    public final Object evaluate(Context context) throws PropertyException {
        try {
            FastWriter fw = FastWriter.getInstance(context.getBroker());
            this.write(fw, context);
            String ret = fw.toString();
            fw.close();
            return ret;
        }
        catch (IOException e) {
            context.getBroker().getLog("engine", "parsing and template execution").error("StringWriter threw an IOException!", e);
            return null;
        }
    }

    private static class BlockIterator
    implements BlockBuilder.BlockIterator {
        private int i = 0;
        private boolean doneString = false;
        private boolean done = false;
        private String[] strings;
        private Macro[] macros;
        private Block block;

        public BlockIterator(String[] strings, Macro[] macros, Block b) {
            this.strings = strings;
            this.macros = macros;
            this.block = b;
        }

        public boolean hasNext() {
            return !this.done;
        }

        public String getName() {
            return this.block.getTemplateName();
        }

        public int getLineNo() {
            return this.block.getLineNo(this.i - 1);
        }

        public int getColNo() {
            return this.block.getColNo(this.i - 1);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this.doneString) {
                this.doneString = false;
                return this.macros[this.i++];
            }
            if (this.i == this.strings.length - 1) {
                this.done = true;
            }
            this.doneString = true;
            return this.strings[this.i];
        }
    }
}

