/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.HashMap;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.Macro;
import org.webmacro.NotFoundException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.ConstantPropertyVariable;
import org.webmacro.engine.FunctionCall;
import org.webmacro.engine.FunctionVariable;
import org.webmacro.engine.GlobalVariable;
import org.webmacro.engine.MacroDefinition;
import org.webmacro.engine.MacroPropertyVariable;
import org.webmacro.engine.Parser;
import org.webmacro.engine.PropertyVariable;
import org.webmacro.engine.SimplePropertyVariable;
import org.webmacro.engine.Variable;

public class BuildContext
extends Context {
    private final Map _types = new HashMap();
    private final Map _macros = new HashMap();

    public BuildContext(Broker b) {
        super(b);
    }

    public final Parser getParser(String pname) throws NotFoundException {
        try {
            return (Parser)this.getBroker().get("parser", pname);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (ResourceException e) {
            throw new NotFoundException(e.toString(), e);
        }
    }

    public Object getVariableType(String name) {
        Object ret = this._types.get(name);
        return ret == null ? Variable.PROPERTY_TYPE : ret;
    }

    public void setVariableType(String name, Object type) {
        if (name == null) {
            return;
        }
        if (type == null) {
            this._types.remove(name);
        } else {
            this._types.put(name, type);
        }
    }

    public void putMacro(String name, MacroDefinition macro) {
        this._macros.put(name, macro);
    }

    public MacroDefinition getMacro(String name) {
        return (MacroDefinition)this._macros.get(name);
    }

    public void mergeConstants(Template t) {
        Map macros = t.getMacros();
        Map params = t.getParameters();
        if (macros != null) {
            this._macros.putAll(macros);
        }
        if (params != null) {
            super.putAll(params);
        }
    }

    public Map getMacros() {
        return this._macros;
    }

    Object resolveVariableReference(Object[] names) throws BuildException {
        Object v = null;
        if (names.length < 1) {
            throw new BuildException("Variable with name of length zero!");
        }
        Object[] c = new Object[names.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = names[i] instanceof Builder ? ((Builder)names[i]).build(this) : names[i];
        }
        String firstName = c[0].toString();
        Object type = null;
        type = c[0] instanceof FunctionCall ? FunctionVariable.TYPE : this.getVariableType(firstName);
        if (type == Variable.PROPERTY_TYPE) {
            Object expansion;
            v = this.containsKey(firstName) ? ((expansion = this.get(firstName)) instanceof Macro ? (c.length == 1 ? expansion : new MacroPropertyVariable((Macro)expansion, c)) : (c.length == 1 ? expansion : new ConstantPropertyVariable(expansion, c))) : (c.length == 1 ? new SimplePropertyVariable(c) : new PropertyVariable(c));
        } else if (type == Variable.LOCAL_TYPE) {
            v = new GlobalVariable(c);
        } else if (type == FunctionVariable.TYPE) {
            v = new FunctionVariable(c);
        } else {
            throw new BuildException("Unrecognized Variable Type: " + type);
        }
        return v;
    }
}

