/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.ListBuilder;
import org.webmacro.engine.MacroDefinition;

public class MacroBuilder
implements Builder {
    private String name;
    private ListBuilder argsBuilder;

    public MacroBuilder(String name, ListBuilder argsBuilder, int lineNo, int colNo) {
        this.name = name;
        this.argsBuilder = argsBuilder;
    }

    public Object build(BuildContext bc) throws BuildException {
        MacroDefinition md = bc.getMacro(this.name);
        if (md == null) {
            boolean relax = bc.getBroker().getBooleanSetting("RelaxedDirectiveBuilding");
            if (relax) {
                return "#" + this.name + " ";
            }
            throw new BuildException("#" + this.name + ": no such Macro or Directive");
        }
        Object[] args = this.argsBuilder.buildAsArray(bc);
        return md.expand(args, bc);
    }
}

