/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.InputStreamReader;
import org.webmacro.Macro;
import org.webmacro.TemplateVisitor;
import org.webmacro.WM;
import org.webmacro.engine.StreamTemplate;
import org.webmacro.engine.Variable;

public class TemplateDumper
extends TemplateVisitor {
    private boolean atBol = true;

    private void print(String s) {
        System.out.print(s);
        this.atBol = false;
    }

    private void println(String s) {
        System.out.println(s);
        this.atBol = true;
    }

    private void println() {
        System.out.println();
        this.atBol = true;
    }

    private void newLine() {
        if (!this.atBol) {
            this.println();
        }
    }

    public void visitString(String s) {
        this.print(s);
    }

    public void beginBlock() {
        this.newLine();
        this.println("#begin");
    }

    public void endBlock() {
        this.newLine();
        this.println("#end");
    }

    public void beginDirective(String directiveName) {
        this.newLine();
        this.print("#" + directiveName + " ");
    }

    public void visitDirectiveArg(String argName, Object o) {
        this.print(":" + argName + ":");
        if (o instanceof Macro) {
            this.visitMacro((Macro)o);
        } else if (o == null) {
            this.print("<NULL>");
        } else {
            this.print(o.toString());
        }
    }

    public void visitBinaryOperation(String opType, Object l, Object r) {
        this.print(opType + "(");
        if (l instanceof Macro) {
            this.visitMacro((Macro)l);
        } else {
            this.print(l != null ? l.toString() : "<NULL>");
        }
        this.print(", ");
        if (r instanceof Macro) {
            this.visitMacro((Macro)r);
        } else {
            this.print(r != null ? r.toString() : "<NULL>");
        }
        this.print(")");
    }

    public void visitUnaryOperation(String opType, Object o) {
        this.print(opType + "(" + (o != null ? o.toString() : "<NULL>") + ")");
    }

    public void visitVariable(Variable v, Object[] names) {
        this.print("$" + v.toString());
    }

    public void visitUnknownMacro(String macroType, Macro m) {
        this.print("[Unknown macro type " + macroType + "]");
    }

    public static void main(String[] args) throws Exception {
        WM wm = new WM();
        StreamTemplate t = new StreamTemplate(wm.getBroker(), new InputStreamReader(System.in));
        t.parse();
        System.out.println("--------");
        TemplateDumper td = new TemplateDumper();
        t.accept(td);
        System.out.println("--------");
    }
}

