/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ASCII_CharStream {
    private Buffer bufA;
    private Buffer bufB;
    private Buffer curBuf;
    private Buffer otherBuf;
    private Buffer tokenBeginBuf;
    private int tokenBeginPos;
    private int backupChars;
    public static final boolean staticFlag = false;
    private int column = 0;
    private int line = 1;
    private boolean prevCharIsCR = false;
    private boolean prevCharIsLF = false;
    private Reader inputStream;

    private final void swapBuf() {
        Buffer tmp = this.curBuf;
        this.curBuf = this.otherBuf;
        this.otherBuf = tmp;
    }

    private final void FillBuff() throws IOException {
        if (this.curBuf.size - this.curBuf.dataLen < 2048) {
            if (this.tokenBeginPos >= 0 && (this.tokenBeginBuf == this.curBuf && this.tokenBeginPos < 2048 || this.tokenBeginBuf != this.curBuf)) {
                this.curBuf.expand(2048);
            } else {
                this.swapBuf();
                this.curBuf.dataLen = 0;
                this.curBuf.curPos = 0;
            }
        }
        try {
            int i = this.inputStream.read(this.curBuf.buffer, this.curBuf.dataLen, this.curBuf.size - this.curBuf.dataLen);
            if (i == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.curBuf.dataLen += i;
            return;
        }
        catch (IOException e) {
            if (this.curBuf.curPos > 0) {
                --this.curBuf.curPos;
            }
            if (this.tokenBeginPos == -1) {
                this.tokenBeginPos = this.curBuf.curPos;
                this.tokenBeginBuf = this.curBuf;
            }
            throw e;
        }
    }

    public final char BeginToken() throws IOException {
        this.tokenBeginPos = -1;
        char c = this.readChar();
        this.tokenBeginBuf = this.curBuf;
        this.tokenBeginPos = this.curBuf.curPos;
        return c;
    }

    private final void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += 8 - (this.column & 7);
                break;
            }
        }
        this.curBuf.bufline[this.curBuf.curPos] = this.line;
        this.curBuf.bufcolumn[this.curBuf.curPos] = this.column;
    }

    public final char readChar() throws IOException {
        if (++this.curBuf.curPos >= this.curBuf.dataLen) {
            if (this.backupChars > 0) {
                --this.curBuf.curPos;
                this.swapBuf();
            } else {
                this.FillBuff();
            }
        }
        char c = (char)(0xFF & this.curBuf.buffer[this.curBuf.curPos]);
        if (this.backupChars > 0) {
            --this.backupChars;
        } else {
            this.UpdateLineColumn(c);
        }
        return c;
    }

    public final int getColumn() {
        return this.curBuf.bufcolumn[this.curBuf.curPos];
    }

    public final int getLine() {
        return this.curBuf.bufline[this.curBuf.curPos];
    }

    public final int getEndColumn() {
        return this.curBuf.bufcolumn[this.curBuf.curPos];
    }

    public final int getEndLine() {
        return this.curBuf.bufline[this.curBuf.curPos];
    }

    public final int getBeginColumn() {
        return this.tokenBeginBuf.bufcolumn[this.tokenBeginPos];
    }

    public final int getBeginLine() {
        return this.tokenBeginBuf.bufline[this.tokenBeginPos];
    }

    public final void backup(int amount) {
        this.backupChars += amount;
        if (this.curBuf.curPos - amount < 0) {
            int addlChars = amount - 1 - this.curBuf.curPos;
            this.curBuf.curPos = 0;
            this.swapBuf();
            this.curBuf.curPos = this.curBuf.dataLen - addlChars - 1;
        } else {
            this.curBuf.curPos -= amount;
        }
    }

    public ASCII_CharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.ReInit(dstream, startline, startcolumn, buffersize);
    }

    public ASCII_CharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.inputStream = dstream;
        this.line = startline;
        this.column = startcolumn - 1;
        if (this.bufA == null || this.bufA.size != buffersize) {
            this.bufA = new Buffer(buffersize);
        }
        if (this.bufB == null || this.bufB.size != buffersize) {
            this.bufB = new Buffer(buffersize);
        }
        this.curBuf = this.bufA;
        this.otherBuf = this.bufB;
        this.otherBuf.dataLen = -1;
        this.curBuf.curPos = -1;
        this.otherBuf.dataLen = 0;
        this.curBuf.dataLen = 0;
        this.prevCharIsCR = false;
        this.prevCharIsLF = false;
        this.tokenBeginPos = -1;
        this.tokenBeginBuf = null;
        this.backupChars = 0;
    }

    public void ReInit(Reader dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public ASCII_CharStream(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public ASCII_CharStream(InputStream dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this.ReInit(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public final String GetImage() {
        if (this.tokenBeginBuf == this.curBuf) {
            return new String(this.curBuf.buffer, this.tokenBeginPos, this.curBuf.curPos - this.tokenBeginPos + 1);
        }
        return new String(this.otherBuf.buffer, this.tokenBeginPos, this.otherBuf.dataLen - this.tokenBeginPos) + new String(this.curBuf.buffer, 0, this.curBuf.curPos + 1);
    }

    public final char[] GetSuffix(int len) {
        char[] ret = new char[len];
        if (this.curBuf.curPos + 1 >= len) {
            System.arraycopy(this.curBuf.buffer, this.curBuf.curPos - len + 1, ret, 0, len);
        } else {
            if (this.otherBuf.dataLen >= len - this.curBuf.curPos - 1) {
                System.arraycopy(this.otherBuf.buffer, this.otherBuf.dataLen - (len - this.curBuf.curPos - 1), ret, 0, len - this.curBuf.curPos - 1);
            }
            System.arraycopy(this.curBuf.buffer, 0, ret, len - this.curBuf.curPos - 1, this.curBuf.curPos + 1);
        }
        return null;
    }

    public void Done() {
        this.otherBuf = null;
        this.curBuf = null;
        this.bufB = null;
        this.bufA = null;
    }

    private static final class Buffer {
        int size;
        int dataLen;
        int curPos;
        char[] buffer;
        int[] bufline;
        int[] bufcolumn;

        public Buffer(int n) {
            this.size = n;
            this.dataLen = 0;
            this.curPos = -1;
            this.buffer = new char[n];
            this.bufline = new int[n];
            this.bufcolumn = new int[n];
        }

        public void expand(int n) {
            char[] newbuffer = new char[this.size + n];
            int[] newbufline = new int[this.size + n];
            int[] newbufcolumn = new int[this.size + n];
            try {
                System.arraycopy(this.buffer, 0, newbuffer, 0, this.size);
                this.buffer = newbuffer;
                System.arraycopy(this.bufline, 0, newbufline, 0, this.size);
                this.bufline = newbufline;
                System.arraycopy(this.bufcolumn, 0, newbufcolumn, 0, this.size);
                this.bufcolumn = newbufcolumn;
            }
            catch (Throwable t) {
                throw new Error(t.getMessage());
            }
            this.size += n;
        }
    }
}

