/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.ResourceException;
import org.webmacro.engine.FileTemplate;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.StreamTemplate;
import org.webmacro.engine.WMTemplate;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CacheReloadContext;
import org.webmacro.resource.InvalidResourceException;
import org.webmacro.resource.ReloadDelayDecorator;
import org.webmacro.resource.ResourceLoader;
import org.webmacro.resource.TemplateProvider;
import org.webmacro.resource.UrlProvider;
import org.webmacro.util.Settings;

public final class BrokerTemplateProviderHelper
implements ResourceLoader {
    private Broker _broker;
    private Log _log;
    private boolean _cacheSupportsReload = true;
    private ReloadDelayDecorator reloadDelay;

    public void init(Broker b, Settings config) throws InitException {
        this._broker = b;
        this._log = b.getLog("resource", "Object loading and caching");
        this.reloadDelay = new ReloadDelayDecorator();
        this.reloadDelay.init(b, config);
    }

    public final Object load(String name, CacheElement ce) throws ResourceException {
        WMTemplate t = null;
        WMTemplate ret = null;
        URL tUrl = this.findTemplate(name);
        try {
            String protocol = tUrl.getProtocol();
            if (protocol.equals("file")) {
                File f = new File(tUrl.getFile());
                long lastMod = f.lastModified();
                t = new FileTemplate(this._broker, f);
                t.parse();
                ret = t;
                if (this._cacheSupportsReload) {
                    TemplateProvider.FTReloadContext reloadContext = new TemplateProvider.FTReloadContext(f, lastMod);
                    ce.setReloadContext(this.reloadDelay.decorate("file", reloadContext));
                }
            } else {
                long lastMod = UrlProvider.getUrlLastModified(tUrl);
                String encoding = tUrl.openConnection().getContentEncoding();
                t = new StreamTemplate(this._broker, UrlProvider.getUrlInputStream(tUrl), encoding);
                t.setName(name);
                t.parse();
                ret = t;
                if (this._cacheSupportsReload) {
                    UrlReloadContext reloadContext = new UrlReloadContext(tUrl, lastMod);
                    ce.setReloadContext(this.reloadDelay.decorate(tUrl.getProtocol(), reloadContext));
                }
            }
        }
        catch (NullPointerException npe) {
            this._log.warning("BrokerTemplateProvider: Template not found: " + name);
        }
        catch (ParseException e) {
            this._log.warning("BrokerTemplateProvider: Error occured while parsing " + name, e);
            throw new InvalidResourceException("Error parsing template " + name, e);
        }
        catch (IOException e) {
            this._log.warning("BrokerTemplateProvider: IOException while parsing " + name, e);
            throw new InvalidResourceException("Error parsing template " + name, e);
        }
        catch (Exception e) {
            this._log.warning("BrokerTemplateProvider: Error occured while fetching " + name, e);
            throw new ResourceException("Error parsing template " + name, e);
        }
        if (ret == null) {
            throw new NotFoundException(this + " could not locate " + name);
        }
        return ret;
    }

    public Object load(Object query, CacheElement ce) throws ResourceException {
        throw new ResourceException("CachingProvider: load(Object) not supported, use load(String)");
    }

    public void setReload(boolean reload) {
        this._cacheSupportsReload = reload;
    }

    private final URL findTemplate(String fileName) {
        URL u;
        if (this._log.loggingDebug()) {
            this._log.debug("Looking for template in class path: " + fileName);
        }
        if ((u = this._broker.getTemplate(fileName)) != null && this._log.loggingDebug()) {
            this._log.debug("BrokerTemplateProvider: Found " + fileName + " at " + u.toString());
        }
        return u;
    }

    private static class UrlReloadContext
    extends CacheReloadContext {
        private long lastModified;
        private URL url;

        public UrlReloadContext(URL url, long lastModified) {
            this.url = url;
            this.lastModified = lastModified;
        }

        public boolean shouldReload() {
            return this.lastModified != UrlProvider.getUrlLastModified(this.url);
        }
    }
}

