/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.Provider;
import org.webmacro.ResourceException;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CacheManager;
import org.webmacro.resource.ResourceLoader;
import org.webmacro.resource.TrivialCacheManager;
import org.webmacro.util.Settings;

public abstract class CachingProvider
implements Provider,
ResourceLoader {
    private CacheManager _cache;
    private Log _log;
    protected boolean _cacheSupportsReload;

    public void init(Broker b, Settings config) throws InitException {
        this._log = b.getLog("resource", "Object loading and caching");
        String cacheManager = b.getSetting("CachingProvider." + this.getType() + ".CacheManager");
        if (cacheManager == null) {
            cacheManager = b.getSetting("CachingProvider.*.CacheManager");
        }
        if (cacheManager == null || cacheManager.equals("")) {
            this._log.info("CachingProvider: No cache manager specified for " + this.getType() + ", using TrivialCacheManager");
            this._cache = new TrivialCacheManager();
        } else {
            try {
                this._cache = (CacheManager)b.classForName(cacheManager).newInstance();
            }
            catch (Exception e) {
                this._log.warning("Unable to load cache manager " + cacheManager + " for resource type " + this.getType() + ", using TrivialCacheManager.  Reason:\n" + e);
                this._cache = new TrivialCacheManager();
            }
        }
        this._cache.init(b, config, this.getType());
        this._cacheSupportsReload = this._cache.supportsReload();
    }

    public void flush() {
        this._cache.flush();
    }

    public void destroy() {
        this._cache.destroy();
    }

    public Object get(String query) throws ResourceException {
        return this._cache.get(query, this);
    }

    public Object load(Object query, CacheElement ce) throws ResourceException {
        return this.load((String)query, ce);
    }

    public String toString() {
        return "CachingProvider(type = " + this.getType() + ")";
    }
}

