/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CachingProvider;
import org.webmacro.resource.TemplateLoader;
import org.webmacro.resource.TemplateLoaderFactory;
import org.webmacro.resource.TemplatePathTemplateLoader;
import org.webmacro.util.Settings;

public class DelegatingTemplateProvider
extends CachingProvider {
    private Log log;
    private TemplateLoaderFactory factory;
    private TemplateLoader[] templateLoaders;

    public void init(Broker broker, Settings config) throws InitException {
        super.init(broker, config);
        this.log = broker.getLog("resource", "DelegatingTemplateProvider");
        String factoryClass = config.getSetting("TemplateLoaderFactory", "");
        this.log.info("DelegatingTemplateProvider: Using TemplateLoaderFactory " + factoryClass);
        this.factory = this.createFactory(factoryClass);
        ArrayList<TemplateLoader> loaders = new ArrayList<TemplateLoader>();
        if (config.getBooleanSetting("DelegatingTemplateProvider.EmulateTemplatePath", false) && config.getSetting("TemplatePath", "").length() > 0) {
            TemplatePathTemplateLoader loader = new TemplatePathTemplateLoader();
            loader.init(broker, config);
            loader.setConfig("");
            loaders.add(loader);
        }
        int i = 0;
        String loader = config.getSetting("TemplateLoaderPath.".concat(String.valueOf(i + 1)));
        while (loader != null) {
            loaders.add(this.factory.getTemplateLoader(broker, loader));
            loader = config.getSetting("TemplateLoaderPath.".concat(String.valueOf(++i + 1)));
        }
        this.templateLoaders = new TemplateLoader[loaders.size()];
        loaders.toArray(this.templateLoaders);
    }

    public String getType() {
        return "template";
    }

    public Object load(String query, CacheElement ce) throws ResourceException {
        for (int i = 0; i < this.templateLoaders.length; ++i) {
            Template t = this.templateLoaders[i].load(query, ce);
            if (t == null) continue;
            return t;
        }
        throw new NotFoundException("Could not locate template " + query);
    }

    public List getTemplateLoaders() {
        return Collections.unmodifiableList(Arrays.asList(this.templateLoaders));
    }

    protected TemplateLoaderFactory createFactory(String classname) throws InitException {
        try {
            return (TemplateLoaderFactory)Class.forName(classname).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InitException("Class " + classname + " for template loader factory not found", e);
        }
        catch (InstantiationException e) {
            throw new InitException("Could not instantiate class " + classname + " for template loader factory", e);
        }
        catch (IllegalAccessException e) {
            throw new InitException("Could not instantiate class " + classname + " for template loader facory", e);
        }
        catch (ClassCastException e) {
            throw new InitException("Class " + classname + " for template loader factory does not implement " + "interface org.webmacro.resource.TemplateLoaderFactory", e);
        }
    }
}

