/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.AbstractTemplateLoader;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.InvalidResourceException;
import org.webmacro.servlet.ServletBroker;
import org.webmacro.util.Settings;

public class ServletContextTemplateLoader
extends AbstractTemplateLoader {
    private ServletContext loader;
    private String path;

    public void init(Broker broker, Settings config) throws InitException {
        super.init(broker, config);
        if (!(broker instanceof ServletBroker)) {
            throw new InitException("ServletContextTemplateLoader only works with instances of org.webmacro.servlet.ServletBroker");
        }
        this.loader = ((ServletBroker)broker).getServletContext();
    }

    public void setConfig(String config) {
        if (config.length() > 0 && !config.endsWith("/")) {
            if (this.log.loggingInfo()) {
                this.log.info("ServletContextTemplateLoader: appending \"/\" to path " + config);
            }
            config = config.concat("/");
        }
        if (!config.startsWith("/")) {
            if (this.log.loggingInfo()) {
                this.log.info("ServletContextTemplateLoader: adding \"/\" at the beginning of path " + config);
            }
            config = "/".concat(config);
        }
        this.path = config;
    }

    public Template load(String query, CacheElement ce) throws ResourceException {
        try {
            URL url = this.loader.getResource(this.path.concat(query));
            if (url != null && this.log.loggingDebug()) {
                this.log.debug("ServletContextTemplateProvider: Found Template " + url.toString());
            }
            return url != null ? this.helper.load(url, ce) : null;
        }
        catch (MalformedURLException e) {
            throw new InvalidResourceException("ServletContextTemplateLoader: Could not load " + query, e);
        }
    }
}

