/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.ResourceException;
import org.webmacro.resource.CacheManager;
import org.webmacro.resource.ResourceLoader;
import org.webmacro.util.Settings;

public class SimpleCacheManager
implements CacheManager {
    private static final String NAME = "SimpleCacheManager";
    private final Map _cache = new ConcurrentHashMap();
    private String _resourceType;
    private Log _log;

    public void init(Broker b, Settings config, String resourceType) throws InitException {
        this._log = b.getLog("resource", "Object loading and caching");
        this._resourceType = resourceType;
        this._log.info("SimpleCacheManager." + this._resourceType);
    }

    public void flush() {
        this._cache.clear();
    }

    public void destroy() {
        this._cache.clear();
    }

    public boolean supportsReload() {
        return false;
    }

    public Object get(Object query, ResourceLoader helper) throws ResourceException {
        Object o = null;
        o = this._cache.get(query);
        if (o == null) {
            o = helper.load(query, null);
            this._cache.put(query, o);
        }
        return o;
    }

    public Object get(Object query) {
        return this._cache.get(query);
    }

    public void put(Object query, Object resource) {
        this._cache.put(query, resource);
    }

    public void invalidate(Object query) {
        this._cache.remove(query);
    }

    public String toString() {
        return "SimpleCacheManager(type = " + this._resourceType + ")";
    }
}

