/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.ResourceException;
import org.webmacro.TemplateException;
import org.webmacro.engine.FileTemplate;
import org.webmacro.resource.BrokerTemplateProviderHelper;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CacheReloadContext;
import org.webmacro.resource.CachingProvider;
import org.webmacro.resource.InvalidResourceException;
import org.webmacro.resource.ReloadDelayDecorator;
import org.webmacro.util.Settings;

public final class TemplateProvider
extends CachingProvider {
    private static String _pathSeparator = ";";
    private String[] _templateDirectory = null;
    private Broker _broker = null;
    private String _templatePath;
    private Log _log;
    private BrokerTemplateProviderHelper _btpHelper;
    private ReloadDelayDecorator reloadDelay;

    public void init(Broker b, Settings config) throws InitException {
        super.init(b, config);
        this._broker = b;
        this._log = b.getLog("resource", "Object loading and caching");
        try {
            this._templatePath = config.getSetting("TemplatePath", "");
            if (this._templatePath.equals("")) {
                this._log.info("Template path is empty; will load from class path");
            } else {
                StringTokenizer st = new StringTokenizer(this._templatePath, _pathSeparator);
                this._templateDirectory = new String[st.countTokens()];
                for (int i = 0; i < this._templateDirectory.length; ++i) {
                    String dir;
                    this._templateDirectory[i] = dir = st.nextToken();
                }
            }
            this.reloadDelay = new ReloadDelayDecorator();
            this.reloadDelay.init(b, config);
            this._btpHelper = new BrokerTemplateProviderHelper();
            this._btpHelper.init(b, config);
            this._btpHelper.setReload(this._cacheSupportsReload);
        }
        catch (Exception e) {
            throw new InitException("Could not initialize", e);
        }
    }

    public final String getType() {
        return "template";
    }

    /*
     * Unable to fully structure code
     */
    public final Object load(String name, CacheElement ce) throws ResourceException {
        ret = null;
        if (this._log.loggingInfo()) {
            this._log.info("Loading template: " + name);
        }
        if ((tFile = this.findFileTemplate(name)) != null) {
            try {
                t = new FileTemplate(this._broker, tFile);
                t.parse();
                ret = t;
                if (!this._cacheSupportsReload) ** GOTO lbl23
                reloadContext = new FTReloadContext(tFile, tFile.lastModified());
                ce.setReloadContext(this.reloadDelay.decorate("file", reloadContext));
            }
            catch (NullPointerException npe) {
                this._log.warning("TemplateProvider: Template not found: " + name, npe);
                throw new ResourceException("Error fetching template " + name, npe);
            }
            catch (TemplateException e) {
                this._log.warning("TemplateProvider: Error occured while parsing " + name, e);
                throw new InvalidResourceException("Error parsing template " + name, e);
            }
            catch (Exception e) {
                this._log.warning("TemplateProvider: Error occured while fetching " + name, e);
                throw new ResourceException("Error fetching template " + name, e);
            }
        } else {
            ret = this._btpHelper.load(name, ce);
        }
lbl23:
        // 3 sources

        if (ret == null) {
            throw new NotFoundException(this + " could not locate " + name + " on path " + this._templatePath);
        }
        return ret;
    }

    private final File findFileTemplate(String fileName) {
        if (this._templateDirectory != null) {
            if (this._log.loggingDebug()) {
                this._log.debug("Looking for template in TemplatePath: " + fileName);
            }
            for (int i = 0; i < this._templateDirectory.length; ++i) {
                String dir = this._templateDirectory[i];
                File tFile = new File(dir, fileName);
                if (!tFile.canRead()) continue;
                if (this._log.loggingDebug()) {
                    this._log.debug("TemplateProvider: Found " + fileName + " in " + dir);
                }
                return tFile;
            }
        }
        return null;
    }

    static {
        try {
            _pathSeparator = System.getProperty("path.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class FTReloadContext
    extends CacheReloadContext {
        private File file;
        private long lastModified;

        public FTReloadContext(File f, long lastModified) {
            this.file = f;
            this.lastModified = lastModified;
        }

        public boolean shouldReload() {
            return this.lastModified != this.file.lastModified();
        }
    }
}

