/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.webmacro.Broker;
import org.webmacro.TemplateException;
import org.webmacro.engine.WMTemplate;
import org.webmacro.servlet.LocaleTool;
import org.webmacro.util.NativeAsciiReader;

public class URLTemplate
extends WMTemplate {
    public static final String RCS = "@(#) $Id: URLTemplate.java,v 1.12 2008/03/20 12:30:09 timp Exp $";
    private final URL _url;
    private File underLyingFile = null;
    private long underLyingFileLastModTime = 0L;
    private final HashMap propertiesCache = new HashMap();
    private String _inputEncoding = null;
    private String _outputEncoding = null;
    private Locale _outputLocale = null;
    private static final Object dummy = new Object();

    public URLTemplate(Broker broker, URL templateURL) {
        super(broker);
        this._url = templateURL;
        String _u = this._url.toExternalForm();
        this._log.debug("URLTemplate: " + _u);
        if (_u.startsWith("jar:")) {
            int p = _u.indexOf("!");
            _u = _u.substring(4, p);
        }
        if (_u.startsWith("file:")) {
            this.underLyingFile = new File(_u.substring(5));
            this.underLyingFileLastModTime = this.underLyingFile.lastModified();
        }
        this.setupLocalProperties();
    }

    public boolean shouldReload() {
        if (this.underLyingFile == null) {
            return false;
        }
        long lastMod = this.underLyingFile.lastModified();
        return lastMod > 0L && lastMod > this.underLyingFileLastModTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupLocalProperties() {
        InputStream is = null;
        URL u = null;
        try {
            u = new URL(this._url, "WebMacro.local");
            this._log.debug("Looking for encodings file: " + u);
            Object obj = this.propertiesCache.get(u);
            if (obj != null) {
                return;
            }
            Properties p = new Properties();
            is = u.openStream();
            p.load(is);
            this._inputEncoding = p.getProperty("TemplateEncoding");
            this._outputEncoding = p.getProperty("TemplateOutputEncoding");
            String loc = p.getProperty("TemplateLocale");
            if (loc != null) {
                this._outputLocale = LocaleTool.buildLocale(loc);
            }
            this.propertiesCache.put(u, dummy);
        }
        catch (Exception e) {
            this.propertiesCache.put(u, dummy);
        }
        finally {
            if (this._inputEncoding == null) {
                this._inputEncoding = this.getDefaultEncoding();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Reader getReader() throws IOException {
        this._log.debug("Using encoding " + this._inputEncoding);
        if (this._inputEncoding.equals("native_ascii")) {
            return new NativeAsciiReader(new InputStreamReader(this._url.openStream(), "ASCII"));
        }
        return new BufferedReader(new InputStreamReader(this._url.openStream(), this._inputEncoding));
    }

    public URL getURL() {
        return this._url;
    }

    public String toString() {
        return "URLTemplate:" + this._url;
    }

    public void parse() throws IOException, TemplateException {
        super.parse();
        if (this._outputEncoding != null && this.getParam("TemplateOutputEncoding") == null) {
            this._log.debug("Setting output encoding to " + this._outputEncoding);
            this.setParam("TemplateOutputEncoding", this._outputEncoding);
        }
        if (this._outputLocale != null && this.getParam("TemplateLocale") == null) {
            this._log.debug("Setting output locale to " + this._outputLocale);
            this.setParam("TemplateLocale", this._outputLocale);
        }
    }
}

