/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import org.webmacro.Broker;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.engine.StringTemplate;
import org.webmacro.servlet.Handler;
import org.webmacro.servlet.HandlerException;
import org.webmacro.servlet.WebContext;

final class ErrorHandler
implements Handler {
    private static final String DEFAULT_ERROR_TEXT = "<HTML><HEAD><TITLE>Error</TITLE></HEAD>\n#set $Response.ContentType = \"text/html\"\n<BODY><H1>Error</H1><HR>$error</BODY></HTML>";
    private Template _errorTemplate = null;

    ErrorHandler() {
    }

    public Template accept(WebContext c) throws HandlerException {
        String templateName;
        Broker broker = c.getBroker();
        try {
            templateName = (String)broker.get("config", "ErrorTemplate");
        }
        catch (ResourceException e) {
            templateName = "error.wm";
        }
        try {
            this._errorTemplate = (Template)broker.get("template", templateName);
        }
        catch (ResourceException e) {
            this._errorTemplate = new StringTemplate(broker, DEFAULT_ERROR_TEXT, "WebMacro default error template");
        }
        return this._errorTemplate;
    }

    public void destroy() {
    }

    public void init() {
    }

    public final String toString() {
        return "WebMacro ErrorHandler";
    }
}

