/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.webmacro.util.EnumIterator;
import org.webmacro.util.PrimitiveArrayIterator;

public final class ListUtil {
    private static ListUtil _singleton = new ListUtil();

    private ListUtil() {
    }

    public static ListUtil getInstance() {
        return _singleton;
    }

    public boolean isList(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof List;
    }

    public boolean isArray(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().isArray();
    }

    public static boolean isEmpty(Object arg) {
        if (arg == null) {
            return true;
        }
        if (arg instanceof List) {
            return ((List)arg).isEmpty();
        }
        if (arg instanceof Object[]) {
            return ((Object[])arg).length == 0;
        }
        if (arg instanceof Iterator) {
            return ((Iterator)arg).hasNext();
        }
        if (arg instanceof Enumeration) {
            return ((Enumeration)arg).hasMoreElements();
        }
        if (arg.getClass().isArray()) {
            return Array.getLength(arg) == 0;
        }
        return true;
    }

    public static List toList(Object arg) {
        List<Object> list = null;
        if (arg instanceof List) {
            list = (List<Object>)arg;
        } else if (arg == null) {
            list = Arrays.asList(new Object[0]);
        } else if (arg instanceof Object[]) {
            list = Arrays.asList((Object[])arg);
        } else if (arg instanceof Iterator) {
            list = ListUtil.iteratorToList((Iterator)arg);
        } else if (arg instanceof Enumeration) {
            list = ListUtil.iteratorToList(new EnumIterator((Enumeration)arg));
        } else if (arg.getClass().isArray()) {
            list = ListUtil.iteratorToList(new PrimitiveArrayIterator(arg));
        } else {
            Object[] oa = new Object[]{arg};
            list = Arrays.asList(oa);
        }
        return list;
    }

    private static List iteratorToList(Iterator iter) {
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (iter instanceof ListIterator) {
            ListIterator li = (ListIterator)iter;
            while (li.hasPrevious()) {
                li.previous();
            }
        }
        return list;
    }

    public static Object getItem(Object[] oa, int pos) {
        if (pos < 0 || pos - 1 > oa.length) {
            throw new IndexOutOfBoundsException("Index must be between 0 and " + (oa.length - 1) + ", user specified " + pos);
        }
        return oa[pos];
    }

    public static Object getItem(List list, int pos) {
        if (pos < 0 || pos + 1 > list.size()) {
            throw new IndexOutOfBoundsException("Index must be between 0 and " + (list.size() - 1) + ", user specified " + pos);
        }
        return list.get(pos);
    }

    public static Object getItem(Object arr, int pos) {
        if (!arr.getClass().isArray()) {
            throw new IllegalArgumentException("The first argument must be of List or array type.");
        }
        return Array.get(arr, pos);
    }

    public static int size(Object[] oa) {
        return oa.length;
    }

    public static int size(List list) {
        return list.size();
    }

    public static int size(Object arr) {
        if (!arr.getClass().isArray()) {
            throw new IllegalArgumentException("The argument must be of List or array type.");
        }
        return Array.getLength(arr);
    }

    public static boolean contains(List list, Object o) {
        return list.contains(o);
    }

    public static boolean contains(Object[] oa, Object o) {
        return ListUtil.contains(Arrays.asList(oa), o);
    }

    public static boolean contains(Object arr, Object o) {
        if (!arr.getClass().isArray()) {
            throw new IllegalArgumentException("The argument must be of List or array type.");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            if (!o.equals(Array.get(arr, i))) continue;
            return true;
        }
        return false;
    }

    public static List split(List arg, int colCount) {
        return ListUtil.split(arg, colCount, true, null);
    }

    public static List split(List arg, int colCount, boolean pad) {
        return ListUtil.split(arg, colCount, pad, null);
    }

    public static List split(List arg, int colCount, Object padValue) {
        return ListUtil.split(arg, colCount, true, padValue);
    }

    public static List split(List arg, int colCount, boolean pad, Object padValue) {
        int size = arg.size();
        ArrayList rows = new ArrayList(size / colCount + 1);
        int start = 0;
        int end = colCount;
        while (start < size) {
            ArrayList<Object> row;
            if (end > size) {
                row = new ArrayList<Object>(arg.subList(start, size));
                if (pad) {
                    for (int i = size; i < end; ++i) {
                        row.add(padValue);
                    }
                }
            } else {
                row = new ArrayList(arg.subList(start, end));
            }
            rows.add(row);
            start = end;
            end += colCount;
        }
        return rows;
    }

    public static Object[] split(Object[] arg, int colCount) {
        return ListUtil.split(arg, colCount, true, null);
    }

    public static Object[] split(Object[] arg, int colCount, boolean pad) {
        return ListUtil.split(arg, colCount, pad, null);
    }

    public static Object[] split(Object[] arg, int colCount, Object padValue) {
        return ListUtil.split(arg, colCount, true, padValue);
    }

    public static Object[][] split(Object[] arg, int colCount, boolean pad, Object padValue) {
        int size = arg.length;
        int rowCount = size / colCount;
        if (size % colCount != 0) {
            ++rowCount;
        }
        Object[][] rows = new Object[rowCount][];
        int start = 0;
        int end = colCount;
        for (int rowNo = 0; rowNo < rowCount; ++rowNo) {
            Object[] row;
            if (end > size) {
                int tail = size - start;
                if (pad) {
                    row = new Object[colCount];
                    System.arraycopy(arg, start, row, 0, tail);
                    if (padValue != null) {
                        for (int i = tail; i < end; ++i) {
                            row[i] = padValue;
                        }
                    }
                } else {
                    row = new Object[tail];
                    System.arraycopy(arg, start, row, 0, tail);
                }
            } else {
                row = new Object[colCount];
                System.arraycopy(arg, start, row, 0, colCount);
            }
            rows[rowNo] = row;
            start = end;
            end += colCount;
        }
        return rows;
    }

    public static Object[][] transposeSplit(Object[] arg, int colCount) {
        return ListUtil.transposeSplit(arg, colCount, true, null);
    }

    public static Object[][] transposeSplit(Object[] arg, int colCount, boolean pad) {
        return ListUtil.transposeSplit(arg, colCount, pad, null);
    }

    public static Object[][] transposeSplit(Object[] arg, int colCount, Object padValue) {
        return ListUtil.transposeSplit(arg, colCount, true, padValue);
    }

    public static Object[][] transposeSplit(Object[] arg, int colCount, boolean pad, Object padValue) {
        Object[][] rows;
        boolean slack;
        int size = arg.length;
        int rowCount = size / colCount;
        boolean bl = slack = size % colCount != 0;
        if (slack) {
            ++rowCount;
        }
        if (slack && !pad) {
            int tail = size % rowCount;
            rows = new Object[rowCount][];
            for (int rowNo = 0; rowNo < rowCount; ++rowNo) {
                rows[rowNo] = rowNo < tail ? new Object[colCount] : new Object[colCount - 1];
            }
        } else {
            rows = new Object[rowCount][colCount];
        }
        int pos = 0;
        block1: for (int colNo = 0; colNo < colCount; ++colNo) {
            for (int rowNo = 0; rowNo < rowCount; ++rowNo) {
                if (pos < size) {
                    rows[rowNo][colNo] = arg[pos++];
                    continue;
                }
                if (!pad) continue block1;
                rows[rowNo][colNo] = padValue;
            }
        }
        return rows;
    }

    public static List transposeSplit(List arg, int colCount) {
        return ListUtil.transposeSplit(arg, colCount, true, null);
    }

    public static List transposeSplit(List arg, int colCount, boolean pad) {
        return ListUtil.transposeSplit(arg, colCount, pad, null);
    }

    public static List transposeSplit(List arg, int colCount, Object padValue) {
        return ListUtil.transposeSplit(arg, colCount, true, padValue);
    }

    public static List transposeSplit(List arg, int colCount, boolean pad, Object padValue) {
        int size = arg.size();
        int rowCount = size / colCount;
        if (size % colCount != 0) {
            ++rowCount;
        }
        ArrayList rows = new ArrayList(rowCount);
        for (int rowNo = 0; rowNo < rowCount; ++rowNo) {
            rows.add(new ArrayList(colCount));
        }
        Iterator it = arg.iterator();
        block1: for (int colNo = 0; colNo < colCount; ++colNo) {
            for (int rowNo = 0; rowNo < rowCount; ++rowNo) {
                List row = (List)rows.get(rowNo);
                if (it.hasNext()) {
                    row.add(it.next());
                    continue;
                }
                if (!pad) continue block1;
                row.add(padValue);
            }
        }
        return rows;
    }

    public static List createRange(int rangeBegin, int rangeEnd) {
        return ListUtil.createRange(rangeBegin, rangeEnd, 1);
    }

    public static List createRange(int rangeBegin, int rangeEnd, int incr) {
        if (incr > 0) {
            if (rangeBegin > rangeEnd) {
                throw new IllegalArgumentException("Starting number must be less than ending number");
            }
        } else if (incr < 0) {
            if (rangeBegin < rangeEnd) {
                throw new IllegalArgumentException("Starting number must be greater than ending number");
            }
        } else {
            throw new IllegalArgumentException("Increment cannot be zero");
        }
        int size = (rangeEnd - rangeBegin) / incr + 1;
        Integer[] ia = new Integer[size];
        int i = 0;
        int num = rangeBegin;
        while (incr > 0 ? num <= rangeEnd : num >= rangeEnd) {
            ia[i++] = new Integer(num);
            num += incr;
        }
        return Arrays.asList(ia);
    }

    public static ArrayList create() {
        return new ArrayList();
    }

    public static ArrayList create(int capacity) {
        return new ArrayList(capacity);
    }

    public static List append(Object o1, Object o2) {
        List l1 = ListUtil.toList(o1);
        List l2 = ListUtil.toList(o2);
        try {
            l1.addAll(l2);
            return l1;
        }
        catch (Exception e) {
            ArrayList l = new ArrayList((l1.size() + l2.size()) * 2 + 10);
            l.addAll(l1);
            l.addAll(l2);
            return l;
        }
    }

    public static List copy(Object o) {
        List l = ListUtil.toList(o);
        if (l.isEmpty()) {
            return new ArrayList(10);
        }
        return new ArrayList(l);
    }

    public static void main(String[] args) {
        int j;
        PrintWriter out = new PrintWriter(System.out, true);
        ListUtil lu = ListUtil.getInstance();
        out.println("createRange(2, 10, 2): " + ListUtil.createRange(2, 10, 2));
        out.println("createRange(-10, 0): " + ListUtil.createRange(-10, 0));
        out.println("createRange(21, 10, -5): " + ListUtil.createRange(21, 10, -5));
        out.println("createRange(21, 21, -5): " + ListUtil.createRange(21, 21, -5));
        Object[] arr = new Object[]{"ant", "bird", "cat", "dog", "elephant", "ferret", "gopher"};
        ArrayList<Object> l = new ArrayList<Object>(Arrays.asList(arr));
        out.println("List/Array results");
        out.print("toList(): ");
        out.println(ListUtil.toList(l) + "/" + ListUtil.toList(arr));
        out.print("size: ");
        out.println(ListUtil.size(l) + "/" + ListUtil.size(arr));
        out.print("contains(\"bird\"): ");
        out.println(ListUtil.contains(l, (Object)"bird") + "/" + ListUtil.contains(arr, (Object)"bird"));
        out.print("contains(\"fish\"): ");
        out.println(ListUtil.contains(l, (Object)"fish") + "/" + ListUtil.contains(arr, (Object)"fish"));
        out.print("isArray: ");
        out.println(lu.isArray(l) + "/" + lu.isArray(arr));
        out.print("isList: ");
        out.println(lu.isList(l) + "/" + lu.isList(arr));
        out.print("getItem(5): ");
        out.println(ListUtil.getItem(l, 5) + "/" + ListUtil.getItem(arr, 5));
        out.print("getItem(0): ");
        try {
            out.println(ListUtil.getItem(l, 0) + "/" + ListUtil.getItem(arr, 0));
        }
        catch (Exception e) {
            out.println(e);
        }
        out.println("toList(null): " + ListUtil.toList(null));
        out.println("toList(\"a string\"): " + ListUtil.toList("a string"));
        StringTokenizer st = new StringTokenizer("This is a bunch of words!");
        List l2 = ListUtil.toList(st);
        out.println("toList(Enumeration): " + l2);
        ListIterator iter = l2.listIterator();
        List l3 = ListUtil.toList(iter);
        out.println("toList(Iterator): " + l3 + ", iter.hasNext(): " + iter.hasNext());
        out.println("List split with fill");
        List splitList1 = ListUtil.split(l, 3, true);
        Iterator it1 = splitList1.iterator();
        while (it1.hasNext()) {
            out.print("-: ");
            List part = (List)it1.next();
            Iterator it2 = part.iterator();
            while (it2.hasNext()) {
                out.print(it2.next() + ", ");
            }
            out.println("*");
        }
        out.println("List transposeSplit");
        List splitList2 = ListUtil.transposeSplit(l, 3, false);
        Iterator it12 = splitList2.iterator();
        while (it12.hasNext()) {
            out.print("-: ");
            List part = (List)it12.next();
            Iterator it2 = part.iterator();
            while (it2.hasNext()) {
                out.print(it2.next() + ", ");
            }
            out.println("*");
        }
        out.println("Array split");
        Object[] splitArray1 = ListUtil.split((Object[])new String[]{"pero"}, 2, false);
        for (int i = 0; i < splitArray1.length; ++i) {
            out.print("-: ");
            Object[] part = (Object[])splitArray1[i];
            for (j = 0; j < part.length; ++j) {
                out.print(part[j] + ", ");
            }
            out.println("*");
        }
        out.println("Array transposeSplit");
        Object[][] splitArray3 = ListUtil.transposeSplit((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18", "19"}, 3, false);
        for (int i = 0; i < splitArray3.length; ++i) {
            out.print("-: ");
            for (j = 0; j < splitArray3[i].length; ++j) {
                out.print(splitArray3[i][j] + ", ");
            }
            out.println("*");
        }
        int[] emptyInts = new int[]{};
        out.println("Empty array of int: isEmpty=" + ListUtil.isEmpty(emptyInts));
        char[] chars = new char[]{'A', 'B', 'C'};
        out.println("Array of char: isEmpty=" + ListUtil.isEmpty(chars) + ", size=" + ListUtil.size((Object)chars));
        out.println("contains 'C'=" + ListUtil.contains((Object)chars, (Object)new Character('C')));
        out.println("contains 'Z'=" + ListUtil.contains((Object)chars, (Object)new Character('Z')));
        out.println("toList=" + ListUtil.toList(chars));
        float[] f = new float[]{1.1f, 2.2f, 3.3f};
        out.println("getItem(floats, 0)=" + ListUtil.getItem((Object)f, 0));
        List appendList = ListUtil.append(f, chars);
        out.println("append(f, chars)=" + appendList);
        ListUtil.append(appendList, "another thing");
        out.println("append(appendList, \"another thing\")=" + appendList);
    }
}

