/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.Context;
import org.webmacro.Log;
import org.webmacro.servlet.ServletRouter;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Settings;
import org.webmacro.util.WMEval;

public class TemplateServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected WMEval wm;
    protected Context globalContext;
    protected String globalName;
    protected String globalTemplate;
    protected String requestName;
    protected String requestTemplate;
    private static String defaultTemplate = "index.tml";
    private ServletRouter servletRouter;
    protected Log log;

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        try {
            String sr;
            this.wm = new WMEval((Servlet)this);
            this.log = this.wm.getLog();
            Settings settings = this.wm.getSettings();
            this.log("Settings: " + settings.getAsProperties());
            this.globalName = settings.getSetting("GlobalTemplate.ContextName", null);
            this.globalTemplate = settings.getSetting("GlobalTemplate.Resource", null);
            this.requestName = settings.getSetting("RequestTemplate.ContextName", null);
            this.requestTemplate = settings.getSetting("RequestTemplate.Resource", null);
            String w = settings.getSetting("TemplateServlet.DefaultTemplate");
            if (w != null) {
                defaultTemplate = w;
            }
            if ((sr = settings.getSetting("TemplateServlet.ServletRouter")) != null) {
                this.servletRouter = (ServletRouter)Class.forName(sr).newInstance();
            }
            this.refreshGlobalContext();
            this.log("TemplateServlet initialized.");
        }
        catch (Exception e) {
            this.wm.error("Unable to initialize", e);
            e.printStackTrace(System.err);
            this.log("TemplateServlet failed to initialize: " + e.toString());
            throw new ServletException(e.toString());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.doResponse(req, resp);
        }
        catch (Exception e) {
            this.log("Unable to return a template using " + req, e);
            e.printStackTrace(System.err);
            throw new ServletException(e.toString());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected String doResponse(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String templateName = this.locateTemplate(request);
        WebContext context = this.wm.getNewContext(request, response);
        this.loadGlobalContext(context);
        this.loadRequestContext(context, templateName, request, response);
        this.loadDelegationContext(context, templateName, request, response);
        return this.wm.eval(context, templateName, response);
    }

    protected String locateTemplate(HttpServletRequest request) {
        String value = null;
        value = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (value == null) {
            value = request.getServletPath();
        }
        this.log.info("request.getPathInfo(): " + request.getPathInfo());
        this.log.info("javax.servlet.include.servlet_path: " + request.getAttribute("javax.servlet.include.servlet_path"));
        this.log.info("request.getServletPath(): " + request.getServletPath());
        if (value == null || value.trim().length() == 0) {
            return defaultTemplate;
        }
        if (value.endsWith("/")) {
            return value + defaultTemplate;
        }
        return value;
    }

    protected void loadRequestContext(WebContext context, String template, HttpServletRequest request, HttpServletResponse resp) throws ServletException {
        if (this.requestName != null) {
            try {
                Context c = this.wm.getNewContext();
                this.wm.eval(c, this.requestTemplate, null);
                context.put((Object)this.requestName, c);
            }
            catch (Exception e) {
                this.log("Unable to evaluate request template " + this.requestName, e);
                throw new ServletException(e.toString());
            }
        }
    }

    protected void loadDelegationContext(WebContext context, String template, HttpServletRequest request, HttpServletResponse resp) throws ServletException {
        if (this.servletRouter != null) {
            try {
                this.servletRouter.handleWebRequest(this, context, template);
            }
            catch (Exception e) {
                this.log("Unable to process router " + this.servletRouter.getClass().getName(), e);
                throw new ServletException(e.toString());
            }
        }
    }

    private void loadGlobalContext(WebContext context) {
        if (this.globalName == null) {
            return;
        }
        context.put((Object)this.globalName, this.globalContext);
    }

    protected void refreshGlobalContext() throws Exception {
        if (this.globalName == null) {
            return;
        }
        Context c = this.wm.getNewContext();
        this.wm.eval(c, this.globalTemplate, null);
        this.globalContext = c;
    }
}

