/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.webmacro.Context;
import org.webmacro.ContextTool;
import org.webmacro.PropertyException;
import org.webmacro.WebMacroRuntimeException;
import org.webmacro.util.HTMLEscaper;

public class TextTool
extends ContextTool {
    private static final TextTool _instance = new TextTool();

    public static TextTool getInstance() {
        return _instance;
    }

    public static String[] split(String input, String delimiter) {
        int idx;
        if (input == null || delimiter == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int delimlen = delimiter.length();
        int lastidx = 0;
        while ((idx = input.indexOf(delimiter, lastidx)) > -1) {
            l.add(input.substring(lastidx, idx));
            lastidx = idx + delimlen;
        }
        if (lastidx < input.length()) {
            l.add(input.substring(lastidx));
        }
        return l.toArray(new String[0]);
    }

    public static String join(String[] input, String delimiter) {
        if (input == null || delimiter == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < input.length; ++x) {
            if (x > 0) {
                sb.append(delimiter);
            }
            sb.append(input[x]);
        }
        return sb.toString();
    }

    public static String replace(String src, String from, String to) {
        int idx;
        if (src == null || from == null || to == null) {
            return src;
        }
        int fromlen = from.length();
        int lastidx = 0;
        StringBuffer newstr = new StringBuffer();
        while ((idx = src.indexOf(from, lastidx)) > -1) {
            newstr.append(src.substring(lastidx, idx));
            newstr.append(to);
            lastidx = idx + fromlen;
        }
        if (lastidx == 0) {
            return src;
        }
        newstr.append(src.substring(lastidx));
        return newstr.toString();
    }

    public static String URLEncode(String input) {
        if (input == null) {
            return null;
        }
        try {
            return URLEncoder.encode(input, System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebMacroRuntimeException("WebMacro bug System.file.encoding not supported", e);
        }
    }

    public static String URLDecode(String input) {
        if (input == null) {
            return null;
        }
        try {
            return URLDecoder.decode(input, System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebMacroRuntimeException("WebMacro bug System.file.encoding not supported", e);
        }
    }

    public static String HTMLEncode(String input) {
        return input == null ? "" : HTMLEscaper.escape(input);
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String streamToString(InputStream in) throws IOException {
        return TextTool.streamToString(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream in, String encoding) throws IOException {
        if (in == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int cnt;
            byte[] buff = new byte[4096];
            while ((cnt = in.read(buff)) > -1) {
                if (encoding != null) {
                    sb.append(new String(buff, 0, cnt, encoding));
                    continue;
                }
                sb.append(new String(buff, 0, cnt));
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes);
    }

    public static String bytesToString(byte[] bytes, String encoding) throws UnsupportedEncodingException {
        return new String(bytes, encoding);
    }

    public static String trim(String s) {
        return s.trim();
    }

    public static String ltrim(String s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.substring(i);
        }
        return "";
    }

    public static String rtrim(String s) {
        if (s == null) {
            return null;
        }
        for (int i = s.length() - 1; i > -1; --i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.substring(0, i + 1);
        }
        return "";
    }

    public static String[] getLines(String block) {
        if (block == null) {
            return null;
        }
        String delim = "\r\n";
        if (block.indexOf("\r\n") == -1) {
            delim = block.indexOf(10) > -1 ? "\n" : "\r";
        }
        return TextTool.split(block, delim);
    }

    public static String makeBlock(String[] lines) {
        if (lines == null || lines.length == 0) {
            return null;
        }
        if (lines.length == 1) {
            return lines[0];
        }
        StringBuffer sb = new StringBuffer(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            sb.append('\r').append('\n').append(lines[i]);
        }
        return sb.toString();
    }

    public static String trimBlock(String block) {
        if (block == null) {
            return null;
        }
        String[] lines = TextTool.getLines(block);
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = TextTool.trim(lines[i]);
        }
        return TextTool.makeBlock(lines);
    }

    public static String ltrimBlock(String block) {
        if (block == null) {
            return null;
        }
        String[] lines = TextTool.getLines(block);
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = TextTool.ltrim(lines[i]);
        }
        return TextTool.makeBlock(lines);
    }

    public static String rtrimBlock(String block) {
        if (block == null) {
            return null;
        }
        String[] lines = TextTool.getLines(block);
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = TextTool.rtrim(lines[i]);
        }
        return TextTool.makeBlock(lines);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase();
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase();
    }

    public TextTool() {
    }

    public TextTool(Context context) {
    }

    public Object init(Context context) throws PropertyException {
        return TextTool.getInstance();
    }

    public static void main(String[] args) throws Exception {
        String input1 = "This is a test";
        String input2 = "This is a test";
        String[] split = TextTool.split(input2, " ");
        System.err.println(TextTool.replace(input1, "is", "isn't"));
        for (int x = 0; x < split.length; ++x) {
            System.err.println("/" + split[x] + "/");
        }
        String s1 = "alpha\r\nbeta\r\ndelta\r\ngamma";
        String[] split2 = TextTool.split(s1, "\r\n");
        System.err.println("split2=" + Arrays.asList(split2));
    }
}

