/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.tools;

import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import org.webmacro.Broker;
import org.webmacro.WM;
import org.webmacro.engine.BlockBuilder;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.Parser;

public class CheckTemplates {
    private static Parser parser;
    private static Broker broker;

    private CheckTemplates() {
    }

    public static void parseTemplate(String name, Reader in) {
        try {
            BlockBuilder bb = parser.parseBlock(name, in);
            bb.build(new BuildContext(broker));
        }
        catch (Exception e) {
            System.err.println("Exception parsing template " + name + "\n" + e);
        }
    }

    public static void main(String[] args) throws Exception {
        if (!System.getProperties().containsKey("org.webmacro.LogLevel")) {
            System.getProperties().setProperty("org.webmacro.LogLevel", "ERROR");
        }
        WM wm = new WM();
        broker = wm.getBroker();
        parser = (Parser)broker.get("parser", "wm");
        if (args.length == 0) {
            CheckTemplates.parseTemplate("Standard in", new InputStreamReader(System.in));
        } else {
            for (int i = 0; i < args.length; ++i) {
                CheckTemplates.parseTemplate(args[i], new FileReader(args[i]));
            }
        }
    }
}

