/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

public final class Base64 {
    private static final byte UPPER_FOUR = -16;
    private static final byte LOWER_FOUR = 15;
    private static final byte UPPER_SIX = -4;
    private static final byte LOWER_TWO = 3;
    private static final byte UPPER_TWO = -64;
    private static final byte LOWER_SIX = 63;

    private Base64() {
    }

    public static final String decode(String encoded) {
        return Base64.decode(encoded.getBytes());
    }

    public static final String encode(String plainText) {
        return Base64.encode(plainText.getBytes());
    }

    public static final String decode(byte[] encoded) {
        byte[] plain = new byte[(int)((double)encoded.length * 0.75) + 2];
        int ppos = 0;
        boolean cutShort = false;
        for (int epos = 0; epos < encoded.length; ++epos) {
            byte code = Base64.sixBits(encoded[epos]);
            byte ptext = (byte)(code << 2);
            ++epos;
            try {
                code = Base64.sixBits(encoded[epos]);
            }
            catch (Exception e) {
                code = 0;
                cutShort = true;
            }
            ptext = (byte)(ptext | (code & 0xFFFFFFF0) >>> 4);
            plain[ppos++] = ptext;
            if (cutShort) break;
            ptext = (byte)((code & 0xF) << 4);
            ++epos;
            try {
                code = Base64.sixBits(encoded[epos]);
            }
            catch (Exception e) {
                code = 0;
            }
            ptext = (byte)(ptext | (code & 0xFFFFFFFC) >>> 2);
            plain[ppos++] = ptext;
            if (cutShort) break;
            ptext = (byte)((code & 3) << 6);
            ++epos;
            try {
                code = Base64.sixBits(encoded[epos]);
            }
            catch (Exception e) {
                code = 0;
            }
            ptext = (byte)(ptext | code);
            plain[ppos++] = ptext;
        }
        return new String(plain);
    }

    public static final String encode(byte[] plain) {
        StringBuffer encoded = new StringBuffer((int)((double)plain.length * 1.34) + 1);
        boolean cutShort = false;
        for (int ppos = 0; ppos < plain.length; ++ppos) {
            byte ptext = plain[ppos];
            byte sixbits = (byte)((ptext & 0xFFFFFFFC) >>> 2);
            encoded.append(Base64.base64(sixbits));
            sixbits = (byte)((ptext & 3) << 4);
            ++ppos;
            try {
                ptext = plain[ppos];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ptext = 0;
                cutShort = true;
            }
            sixbits = (byte)(sixbits | (byte)((ptext & 0xFFFFFFF0) >>> 4));
            encoded.append(Base64.base64(sixbits));
            if (cutShort) {
                encoded.append("==");
                return encoded.toString();
            }
            sixbits = (byte)((ptext & 0xF) << 2);
            ++ppos;
            try {
                ptext = plain[ppos];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ptext = 0;
                cutShort = true;
            }
            sixbits = (byte)(sixbits | (byte)((ptext & 0xFFFFFFC0) >>> 6));
            encoded.append(Base64.base64(sixbits));
            if (cutShort) {
                encoded.append("=");
                return encoded.toString();
            }
            sixbits = (byte)(ptext & 0x3F);
            encoded.append(Base64.base64(sixbits));
        }
        return encoded.toString();
    }

    private static byte sixBits(byte base64) {
        if (base64 >= 65 && base64 <= 90) {
            return (byte)(base64 - 65);
        }
        if (base64 >= 97 && base64 <= 122) {
            return (byte)(base64 - 97 + 26);
        }
        if (base64 >= 48 && base64 <= 57) {
            return (byte)(base64 - 48 + 52);
        }
        if (base64 == 43) {
            return 62;
        }
        if (base64 == 47) {
            return 63;
        }
        if (base64 == 61) {
            return 0;
        }
        throw new NumberFormatException("Not a base64 character: " + base64);
    }

    private static char base64(byte sixBits) {
        if (sixBits <= 25) {
            return (char)(65 + sixBits);
        }
        if (sixBits <= 51) {
            return (char)(97 + sixBits - 26);
        }
        if (sixBits <= 61) {
            return (char)(48 + sixBits - 52);
        }
        if (sixBits == 62) {
            return '+';
        }
        if (sixBits == 63) {
            return '/';
        }
        throw new NumberFormatException("Not a base64 digit: " + sixBits);
    }

    public static void main(String[] arg) {
        boolean encode;
        if (arg.length < 2) {
            System.out.println("Usage: Base64 encode|decode string");
            return;
        }
        if (arg[0].equals("encode")) {
            encode = true;
        } else if (arg[0].equals("decode")) {
            encode = false;
        } else {
            System.out.println("Unrecognized argument: " + arg[0]);
            return;
        }
        System.out.println(encode ? Base64.encode(arg[1]) : Base64.decode(arg[1]));
    }
}

