/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import org.webmacro.PropertyException;

public final class CastUtil {
    private static CastUtil _singleton = new CastUtil();
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;

    private CastUtil() {
    }

    public static CastUtil getInstance() {
        return _singleton;
    }

    public static Boolean toBoolean(Object o) {
        if (o == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(o.toString());
    }

    public static Character toChar(Object o) throws PropertyException {
        Character c = null;
        if (o == null || o == "") {
            return null;
        }
        if (o instanceof Character) {
            return (Character)o;
        }
        if (o instanceof Number) {
            try {
                c = new Character((char)((Number)o).intValue());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not a valid char: " + o.toString() + "; type=" + o.getClass().getName());
            }
        } else if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("\\u") && s.length() == 6) {
                int i = Integer.parseInt(s.substring(2), 16);
                c = new Character((char)i);
            } else {
                char ch = s.charAt(0);
                c = new Character(ch);
            }
        } else {
            throw new PropertyException("$Type.toChar() is unable to convert the supplied value to a Character.  The argument must be a number or a String.  The supplied argument was " + o + " of type " + o.getClass().getName());
        }
        return c;
    }

    public static Byte toByte(Object o) {
        if (o instanceof Byte) {
            return (Byte)o;
        }
        Byte v = null;
        try {
            int i = Integer.parseInt(o.toString());
            v = new Byte((byte)i);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid byte: " + (o == null ? "null" : o.toString() + "; type=" + o.getClass().getName()));
        }
        return v;
    }

    public static Short toShort(Object o) {
        if (o instanceof Short) {
            return (Short)o;
        }
        Short v = null;
        try {
            int i = Integer.parseInt(o.toString());
            v = new Short((short)i);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid short: " + (o == null ? "null" : o.toString() + "; type=" + o.getClass().getName()));
        }
        return v;
    }

    public static Integer toInt(Object o) {
        Integer i = null;
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            i = new Integer(o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid int: " + (o == null ? "null" : o.toString() + "; type=" + o.getClass().getName()));
        }
        return i;
    }

    public static Long toLong(Object o) {
        Long l = null;
        if (o instanceof Long) {
            return (Long)o;
        }
        try {
            l = new Long(o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid long: " + (o == null ? "null" : o.toString() + "; type=" + o.getClass().getName()));
        }
        return l;
    }

    public static Float toFloat(Object o) {
        Float f = null;
        if (o instanceof Float) {
            return (Float)o;
        }
        try {
            f = new Float(o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid float: " + (o == null ? "null" : o.toString() + "; type=" + o.getClass().getName()));
        }
        return f;
    }

    public static Double toDouble(Object o) {
        Double d = null;
        if (o instanceof Double) {
            return (Double)o;
        }
        try {
            d = new Double(o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid double: " + (o == null ? "null" : o.toString() + "; type=" + o.getClass().getName()));
        }
        return d;
    }

    public static String toString(Object o) {
        return o != null ? o.toString() : null;
    }

    public static void main(String[] args) {
        CastUtil.println("77" + CastUtil.test(1, "77") + CastUtil.test(2, "77") + CastUtil.test(3, "77") + CastUtil.test(4, "77") + CastUtil.test(5, "77") + CastUtil.test(6, "77") + CastUtil.test(7, "77") + CastUtil.test(8, "77") + ".");
        CastUtil.println("true: " + CastUtil.test(1, "true") + ".");
        CastUtil.println("FalSE: " + CastUtil.test(1, "FalSE") + ".");
        CastUtil.println("null: " + CastUtil.test(1, null) + ".");
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String test(int type, Object val) {
        String s = null;
        try {
            Comparable<Boolean> o = null;
            switch (type) {
                case 1: {
                    o = CastUtil.toBoolean(val);
                    break;
                }
                case 2: {
                    o = CastUtil.toChar(val);
                    break;
                }
                case 3: {
                    o = CastUtil.toByte(val);
                    break;
                }
                case 4: {
                    o = CastUtil.toShort(val);
                    break;
                }
                case 5: {
                    o = CastUtil.toInt(val);
                    break;
                }
                case 6: {
                    o = CastUtil.toLong(val);
                    break;
                }
                case 7: {
                    o = CastUtil.toFloat(val);
                    break;
                }
                case 8: {
                    o = CastUtil.toDouble(val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
            }
            s = ", " + o + " (" + o.getClass().getName() + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }
}

