/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.webmacro.WebMacroRuntimeException;
import org.webmacro.util.LogSystem;
import org.webmacro.util.LogTarget;

public class CommonsLoggingTarget
implements LogTarget {
    static final Log log = LogFactory.getLog((Class)CommonsLoggingTarget.class);

    public void log(Date date, String type, String level, String message, Throwable e) {
        int logLevel = LogSystem.getLevel(level);
        switch (logLevel) {
            case 0: {
                log.debug((Object)message, e);
                break;
            }
            case 4: {
                log.error((Object)message, e);
                break;
            }
            case 1: {
                log.trace((Object)message, e);
                break;
            }
            case 2: {
                log.info((Object)message, e);
                break;
            }
            case 3: {
                log.warn((Object)message, e);
                break;
            }
            default: {
                throw new WebMacroRuntimeException("Unanticipated value for LogLevel: (" + level + ") " + logLevel);
            }
        }
    }

    public void flush() {
    }

    public boolean subscribe(String category, String type, int logLevel) {
        boolean sub = false;
        switch (logLevel) {
            case 0: {
                sub = log.isDebugEnabled();
                break;
            }
            case 4: {
                sub = log.isErrorEnabled();
                break;
            }
            case 1: {
                sub = log.isTraceEnabled();
                break;
            }
            case 2: {
                sub = log.isInfoEnabled();
                break;
            }
            case 3: {
                sub = log.isWarnEnabled();
                break;
            }
            default: {
                throw new WebMacroRuntimeException("Unanticipated value for LogLevel: " + logLevel);
            }
        }
        return sub;
    }

    public void addObserver(LogSystem ls) {
    }

    public void removeObserver(LogSystem ls) {
    }
}

