/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.webmacro.util.AbstractLogFile;
import org.webmacro.util.Clock;
import org.webmacro.util.Settings;

public class LogFile
extends AbstractLogFile {
    private PrintStream _out;
    private boolean _logFilePerDay = false;
    private boolean _logFileAutoFlush = false;
    private String _prevLogDate = "";
    private String _actLogDate = "";
    private SimpleDateFormat _logFileSuffix = new SimpleDateFormat("_yyyyMMdd");
    private String _orgLogFile = "";

    public LogFile(Settings s) throws FileNotFoundException {
        super(s);
        String strLogFileAutoFlush;
        this.init(s.getSetting("LogFile"));
        String strLogFilePerDay = s.getSetting("LogFilePerDay");
        if (strLogFilePerDay != null && strLogFilePerDay.equals("TRUE")) {
            this._logFilePerDay = true;
        }
        if ((strLogFileAutoFlush = s.getSetting("LogFileAutoFlush")) != null && strLogFileAutoFlush.equals("TRUE")) {
            this._logFileAutoFlush = true;
        }
    }

    public LogFile(String fileName) throws FileNotFoundException {
        this.init(fileName);
    }

    private void init(String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equalsIgnoreCase("system.err") || fileName.equalsIgnoreCase("none") || fileName.equalsIgnoreCase("stderr")) {
            this._out = System.err;
            this._name = "System.err";
        } else {
            if (this._logFilePerDay) {
                this._orgLogFile = fileName;
                this._prevLogDate = this._actLogDate = this._logFileSuffix.format(Calendar.getInstance().getTime());
                fileName = fileName + this._actLogDate;
            }
            this._out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName, true)));
            this._name = fileName;
            if (this._orgLogFile.length() == 0) {
                this._orgLogFile = fileName;
            }
        }
        if (this._defaultLevel <= 2) {
            this.log(Clock.getDate(), "LogFile", "NOTICE", "--- Log Started ---", null);
        }
    }

    public LogFile(PrintStream out) {
        this._out = out;
        this._name = out.toString();
    }

    public void log(Date date, String name, String level, String message, Throwable e) {
        if (this._logFilePerDay) {
            this._actLogDate = this._logFileSuffix.format(Calendar.getInstance().getTime());
            if (!this._actLogDate.equals(this._prevLogDate)) {
                try {
                    this.init(this._orgLogFile);
                }
                catch (FileNotFoundException f_ex) {
                    System.out.println("Logfile " + this._name + " not found");
                }
            }
        }
        Object[] _args = new Object[]{date, name, level, message};
        this._out.println(this._mf.format(_args));
        if (this._trace && e != null) {
            e.printStackTrace(this._out);
        }
        if (this._logFileAutoFlush) {
            this.flush();
        }
    }

    public void flush() {
        this._out.flush();
    }
}

