/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.webmacro.InitException;
import org.webmacro.util.SubSettings;

public class Settings {
    protected static final String[] stringArray = new String[0];
    private Properties _props = new Properties();

    public Settings() {
    }

    public Settings(String settingsFile) throws InitException, IOException {
        this();
        this.load(settingsFile);
    }

    public Settings(URL settingsFile) throws InitException, IOException {
        this();
        this.load(settingsFile);
    }

    protected Settings(Properties values) {
        this();
        this.load(values);
    }

    public Settings(Settings defaults) {
        this();
        this.load(defaults);
    }

    public void load(String fileName) throws InitException, IOException {
        URL u;
        ClassLoader cl = this.getClass().getClassLoader();
        URL uRL = u = cl == null ? null : cl.getResource(fileName);
        if (u == null) {
            u = ClassLoader.getSystemResource(fileName);
        }
        if (u == null) {
            try {
                u = new URL("file:" + fileName);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (u == null) {
            StringBuffer error = new StringBuffer();
            error.append("Unable to load the properties file: ");
            error.append(fileName);
            error.append(" via the class path\n");
            error.append("This indicates a configuration error.");
            throw new InitException(error.toString());
        }
        this.load(u);
    }

    public void load(URL u) throws IOException {
        InputStream in = u.openStream();
        this._props.load(in);
        in.close();
    }

    public void load(InputStream in) throws IOException {
        this._props.load(in);
    }

    public void load(Settings defaults) {
        String[] keys = defaults.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this._props.setProperty(keys[i], defaults.getSetting(keys[i]));
        }
    }

    public void load(Properties props, String prefix) {
        String dotPrefix;
        Enumeration<?> e = props.propertyNames();
        String string = dotPrefix = prefix == null ? "" : prefix + ".";
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (prefix == null) {
                this._props.setProperty(key, props.getProperty(key));
                continue;
            }
            if (!key.startsWith(dotPrefix)) continue;
            this._props.setProperty(key.substring(dotPrefix.length()), props.getProperty(key));
        }
    }

    public void load(Properties props) {
        this.load(props, null);
    }

    public boolean containsKey(String key) {
        return this._props.containsKey(key);
    }

    public String getSetting(String key) {
        String prop = this._props.getProperty(key);
        if (prop != null) {
            prop = prop.trim();
        }
        if (prop != null && prop.length() > 2 && prop.charAt(0) == '\"' && prop.charAt(prop.length() - 1) == '\"') {
            prop = prop.substring(1, prop.length() - 1);
        }
        return prop;
    }

    public String getSetting(String key, String defaultValue) {
        String ret = this.getSetting(key);
        return ret != null ? ret : defaultValue;
    }

    public int getIntegerSetting(String key) {
        return this.getIntegerSetting(key, 0);
    }

    public int getIntegerSetting(String key, int defaultValue) {
        if (this.containsKey(key)) {
            try {
                return Integer.parseInt(this.getSetting(key));
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBooleanSetting(String key) {
        String setting = this.getSetting(key);
        return setting != null && (setting.equalsIgnoreCase("on") || setting.equalsIgnoreCase("true") || setting.equalsIgnoreCase("yes"));
    }

    public boolean getBooleanSetting(String key, boolean defaultValue) {
        if (this.containsKey(key)) {
            return this.getBooleanSetting(key);
        }
        return defaultValue;
    }

    public String[] getKeys() {
        return this._props.keySet().toArray(stringArray);
    }

    public Properties getAsProperties() {
        String[] keys = this.getKeys();
        Properties p = new Properties();
        for (int i = 0; i < keys.length; ++i) {
            p.setProperty(keys[i], this.getSetting(keys[i]));
        }
        return p;
    }

    public void processListSetting(String settingName, ListSettingHandler h) {
        String listNames = this.getSetting(settingName);
        if (listNames != null) {
            StringTokenizer denum = new StringTokenizer(listNames);
            while (denum.hasMoreElements()) {
                h.processSetting("", (String)denum.nextElement());
            }
        }
        SubSettings s = new SubSettings(this, settingName);
        String[] keys = ((Settings)s).getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String value = ((Settings)s).getSetting(keys[i]).trim();
            if (value.equals("")) continue;
            h.processSetting(keys[i], value);
        }
    }

    public static void main(String[] arg) throws Exception {
        Settings s = new Settings();
        s.load("Test.properties");
        SubSettings sb = new SubSettings(s, "b");
        String[] keys = ((Settings)sb).getKeys();
        for (int i = 0; i < keys.length; ++i) {
            System.out.println("sub-prop " + keys[i] + " = " + ((Settings)sb).getSetting(keys[i]));
        }
        SubSettings ssb = new SubSettings(sb, "b");
        keys = ((Settings)ssb).getKeys();
        for (int i = 0; i < keys.length; ++i) {
            System.out.println("sub-sub-prop " + keys[i] + " = " + ((Settings)ssb).getSetting(keys[i]));
        }
        System.out.println("LogTraceExceptions is: " + s.getBooleanSetting("LogTraceExceptions"));
    }

    public static abstract class ListSettingHandler {
        public abstract void processSetting(String var1, String var2);
    }
}

