/*
 * Decompiled with CFR 0.152.
 */
package easysoft.rpc;

import easysoft.rpc.Function;
import easysoft.rpc.Packet;
import easysoft.rpc.Stub;
import easysoft.rpc.rpcException;
import easysoft.sql.SBFM;
import easysoft.sql.jobConnection;
import easysoft.sql.jobDriver;
import easysoft.sql.jobTrace;
import java.awt.Choice;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;

public class Client {
    public String host;
    public int port;
    public String dsn;
    public Hashtable functionTable = new Hashtable(100);
    public static TextArea output;
    public static Choice dsnChoice;
    public static TextField sqlText;
    public Socket s;
    public Packet packet;
    public long jobHandle;
    String data;
    byte[] mem;
    int MAXDATALEN = 4096;
    public String RPC_STARTFUNC = "A";
    public String RPC_FUNC = "B";
    public String RPC_ENDFUNC = "C";
    public String RPC_EXEC_FUNC = "D";
    public byte RPC_START_IFRAME = (byte)68;
    public boolean TRACING = false;
    public boolean MULTI = false;
    Object[] returnParams = new Object[10];
    public Stub rpc;
    boolean generateStub = false;
    String traceMessage = "";
    int retryCount = 10;
    public short unicodeFlag = 0;
    public boolean encryption = false;
    public SQLException browseException = null;
    jobConnection jobCon = null;
    public String version = "1.3.2";

    public Client(String string, int n, TextArea textArea, Choice choice, TextField textField, int n2) throws rpcException, SQLException {
        this.host = string;
        this.port = n;
        output = textArea;
        dsnChoice = choice;
        sqlText = textField;
        this.connect();
        this.negotiate();
        try {
            this.packet.socket.setSoTimeout(n2);
            jobTrace.debug("Socket Timeout value is set to" + this.packet.socket.getSoTimeout());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage(), "08S01");
        }
    }

    public Client(String string, int n, boolean bl, boolean bl2) throws rpcException, SQLException {
        this.host = string;
        this.port = n;
        this.generateStub = bl2;
        this.TRACING = bl;
        this.connect();
        this.negotiate();
    }

    public Client(String string, String string2, int n, TextArea textArea, int n2) throws rpcException, SQLException {
        this.dsn = string;
        this.host = string2;
        this.port = n;
        output = textArea;
        this.connect();
        this.negotiate();
        try {
            this.packet.socket.setSoTimeout(n2);
            jobTrace.debug("Socket Timeout value is set to" + this.packet.socket.getSoTimeout());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage(), "08S01");
        }
    }

    private static void abort(String string) throws IOException {
        throw new IOException(string);
    }

    public String byteArray2String(byte[] byArray) throws SQLException {
        return this.byteArray2StringISO(byArray);
    }

    public Object callRemote(String string, String string2, String string3, Object[] objectArray, String[] stringArray) throws SQLException {
        if (this.TRACING) {
            jobTrace.print("*" + string + "." + string2 + " : (" + string3 + ") ");
            int n = 0;
            while (n < objectArray.length) {
                jobTrace.print(" " + stringArray[n] + "=" + objectArray[n]);
                if (n != objectArray.length - 1) {
                    jobTrace.print(",");
                }
                ++n;
            }
            jobTrace.println("");
        }
        Object object = this.callRemote(string3, objectArray);
        if (this.TRACING) {
            jobTrace.println("<-- " + string2 + " : " + object);
        }
        return object;
    }

    public Object callRemote(String string, Object[] objectArray) throws SQLException {
        Packet packet = this.packet;
        synchronized (packet) {
            Object object;
            Number number;
            Function function = (Function)this.functionTable.get(string);
            boolean bl = function.argsCountOut > 1;
            Object[] objectArray2 = new Object[function.argsCountOut];
            this.packet.clear();
            this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
            this.packet.write2Bytes(function.ordinal());
            int n = 0;
            while (n < function.argsCountIn()) {
                Integer n2 = (Integer)function.argTypesIn.elementAt(n);
                switch (n2) {
                    case 16: {
                        number = (Short)objectArray[n];
                        this.packet.write2Bytes(((Short)number).shortValue());
                        break;
                    }
                    case 32: {
                        object = (Long)objectArray[n];
                        this.packet.pushInt32((Long)object);
                        break;
                    }
                    case 100: {
                        String string2 = (String)objectArray[n];
                        this.packet.sendByteArray(this.mygetBytes(string2));
                    }
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < function.argsCountOut()) {
                number = (Integer)function.argTypesOut.elementAt(n3);
                if ((Integer)number == 100) {
                    this.packet.pushInt32(this.MAXDATALEN);
                }
                ++n3;
            }
            this.RPCPostFrame();
            try {
                Object[] objectArray3;
                String string3;
                Number number2;
                this.RPCStartIFrame();
                int n4 = this.RPCPPopInt16("ordinal");
                object = "Return Value not set";
                int n5 = 0;
                while (n5 < function.argsCountOut() - 1) {
                    number2 = (Integer)function.argTypesOut.elementAt(n5);
                    switch ((Integer)number2) {
                        case 16: {
                            short s = (short)this.RPCPPopInt16("Return int2  for " + string);
                            object = new Short(s);
                            jobTrace.print(" |" + n5 + ": " + s);
                            break;
                        }
                        case 32: {
                            long l = this.RPCPPopInt32("Return int4  for " + string);
                            object = new Long(l);
                            jobTrace.print(" |" + n5 + ": " + l);
                            break;
                        }
                        case 100: {
                            long l = this.RPCPPopInt32("MAXDATALEN");
                            object = this.packet.readLenString(l);
                        }
                    }
                    if (bl) {
                        objectArray2[n5 + 1] = object;
                    }
                    ++n5;
                }
                jobTrace.println("");
                number2 = new Short((short)this.RPCPPopInt16("return Status  for " + string));
                if ((Short)number2 == 0) {
                    switch (function.argsCountOut()) {
                        case 1: {
                            Number number3 = number2;
                            return number3;
                        }
                        case 2: {
                            Object object2 = object;
                            return object2;
                        }
                    }
                    Object[] objectArray4 = objectArray2;
                    return objectArray4;
                }
                Serializable serializable = null;
                while ((string3 = (String)this.callRemote(string = "jdbc_getWarnings", objectArray3 = new Object[]{new Long(this.jobHandle)})) != null && string3.length() != 0 || serializable == null) {
                    Serializable serializable2;
                    Object[] objectArray5 = new Object[]{new Long(this.jobHandle)};
                    String string4 = (String)this.callRemote("jdbc_getStatusCode", objectArray5);
                    long l = (Long)this.callRemote("jdbc_getVendorCode", objectArray5);
                    if ((Short)number2 == 1 || (Short)number2 == 100) {
                        switch (function.argsCountOut()) {
                            case 1: {
                                jobTrace.println("[out] none");
                                serializable2 = number2;
                                return serializable2;
                            }
                            case 2: {
                                jobTrace.print("value: " + object);
                                Object object3 = object;
                                return object3;
                            }
                        }
                        jobTrace.println("[out]");
                        Object[] objectArray6 = objectArray2;
                        return objectArray6;
                    }
                    if (string3 == null) {
                        string3 = "Failed to get error message";
                    }
                    if (string4 == null) {
                        string4 = "00000";
                    }
                    serializable2 = new SQLException(string3, string4, (int)l);
                    if (this.jobCon != null) {
                        serializable = jobDriver.extendChain(this.jobCon.getExceptions(), (SQLException)serializable2);
                        continue;
                    }
                    if (serializable != null) {
                        serializable = jobDriver.extendChain((SQLException)serializable, (SQLException)serializable2);
                        continue;
                    }
                    serializable = serializable2;
                }
                throw serializable;
            }
            catch (rpcException rpcException2) {
                throw new SQLException(rpcException2.getMessage(), "08S01");
            }
        }
    }

    public SQLException raiseException(short s) throws SQLException {
        if (s < 0) {
            String string = "jdbc_getWarnings";
            Object[] objectArray = new Object[]{new Long(this.jobHandle)};
            String string2 = (String)this.callRemote(string, objectArray);
            Object[] objectArray2 = new Object[]{new Long(this.jobHandle)};
            String string3 = (String)this.callRemote("jdbc_getStatusCode", objectArray2);
            long l = (Long)this.callRemote("jdbc_getVendorCode", objectArray);
            return new SQLException(string2, string3, (int)l);
        }
        return new SQLException("[JOB] Exception raised possibly in error for statusCode = " + s, "08S01");
    }

    public void close() throws SQLException {
        try {
            if (this.jobCon != null) {
                this.jobCon.close();
            }
            this.s.close();
        }
        catch (Exception exception) {
            throw new SQLException("[JOB] Failed to close socket " + exception.getMessage(), "08S01");
        }
    }

    public void connect() throws rpcException, SQLException {
        try {
            this.s = new Socket(this.host, this.port);
            this.s.setSoTimeout(0);
            jobTrace.println("Connected to " + this.s.getInetAddress() + ":" + this.s.getPort());
            DataInputStream dataInputStream = new DataInputStream(this.s.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.s.getOutputStream());
            this.packet = new Packet(dataInputStream, dataOutputStream, this.s);
            this.s.setTcpNoDelay(true);
            boolean bl = this.s.getTcpNoDelay();
        }
        catch (UnknownHostException unknownHostException) {
            throw new rpcException("unknown host: " + unknownHostException.getMessage());
        }
        catch (rpcException rpcException2) {
            if (rpcException2.getMessage().length() > 18 && rpcException2.getMessage().substring(0, 18).equals("Connection refused") && this.retryCount > 0) {
                try {
                    System.out.println("Active Count: " + Thread.currentThread().toString());
                    Thread.currentThread();
                    Thread.currentThread();
                    Thread.sleep(Thread.activeCount() * 100);
                }
                catch (Exception exception) {
                    System.err.println("failed call to sleep in current thread " + exception.getMessage());
                }
                System.err.println("Attempt to reconnect" + this.retryCount);
                --this.retryCount;
                this.connect();
                return;
            }
            throw new rpcException(rpcException2.getMessage());
        }
        catch (Exception exception) {
            throw new rpcException(exception.getMessage());
        }
    }

    public static void drop(TextArea textArea, String string) {
        if (textArea != null) {
            textArea.appendText(string);
        } else {
            System.out.print(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dumpCode(String string, String string2) throws IOException {
        Object object;
        String string3 = "/*                              \n * Easy RPC                                            \n *                                                     \n * Client RPC stubs generated during function import   \n *                                                     \n * $Id: Client.java,v 1.66 2004/03/23 12:56:04 nick Exp nick $                                                \n *                                                     \n * (c)                                                 \n *                                                     \n *                                               \n *                                                     \n */                                                    \npackage easysoft.rpc;                                  \nimport java.sql.SQLException;\n\n\n /** \n     * an array of strings which specifies the name of the JDBC method  \n     * corresponding to the remote call about to be made                \n     * and the names of the input arguments.                            \n     */ \n public class Stub {                                    \n       public Client cl;                    \n    public String [] trace = new String[20]; \n                                                       \n  public Stub (Client cl) {                            \n   this.cl=cl;                                         \n trace[0] = \"No Trace Info\";                                  \n  }                                                    \n";
        String string4 = "  } \n";
        File file = new File(string);
        if (file.exists()) {
            if (!file.canWrite()) {
                Client.abort("FileCopy: destination file is unwriteable: " + string);
            }
            System.out.print("Overwrite existing file " + string + "? (Y/N): ");
            System.out.flush();
            object = new BufferedReader(new InputStreamReader(System.in));
            String string5 = ((BufferedReader)object).readLine();
            if (!string5.equals("Y") && !string5.equals("y")) {
                Client.abort("FileCopy: existing file was not overwritten.");
            }
        } else {
            File file2;
            object = file.getParent();
            if (object == null) {
                object = System.getProperty("user.dir");
            }
            if (!(file2 = new File((String)object)).exists()) {
                Client.abort("FileCopy: destination directory doesn't exist: " + (String)object);
            }
            if (file2.isFile()) {
                Client.abort("FileCopy: destination is not a directory: " + (String)object);
            }
            if (!file2.canWrite()) {
                Client.abort("FileCopy: destination directory is unwriteable: " + (String)object);
            }
        }
        object = null;
        try {
            object = new FileWriter(file);
            ((Writer)object).write(string3);
            ((OutputStreamWriter)object).write(string2, 0, string2.length());
            ((Writer)object).write(string4);
            Object var8_8 = null;
            if (object == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (object == null) throw throwable;
            try {
                ((OutputStreamWriter)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStreamWriter)object).close();
            return;
        }
        catch (IOException iOException) {}
    }

    public byte[] job_getColumnInfoArray(SBFM sBFM, long l, int n) throws SQLException {
        Packet packet = this.packet;
        synchronized (packet) {
            this.RPCStartOFrame();
            this.RPCPushStringNoNull(this.RPC_EXEC_FUNC, "<RPC_EXEC_FUNC>");
            this.RPCPushInt16((short)11, "<Ordinal>");
            this.RPCPushInt32(l, "hStmt");
            this.RPCPushInt16((short)n, "nextColumn");
            this.RPCPushInt32(4000L, "MAXDATALEN for [out] string startPositions");
            this.RPCPushInt32(4000L, "MAXDATALEN for [out] string tableData ");
            this.RPCPostFrame();
            try {
                this.RPCStartIFrame();
                int n2 = this.RPCPPopInt16("ordinal");
                sBFM.readColumn = this.RPCPPopInt16("readColumn");
                long l2 = this.RPCPPopInt32("MAXDATALEN");
                sBFM.startPositionsBlock = this.packet.readLenMemory((int)l2);
                sBFM.rowCount = (int)(l2 / 4L);
                sBFM.columnCount = 6;
                l2 = this.RPCPPopInt32("MAXDATALEN");
                sBFM.tableDataBlock = this.packet.readLenMemory((int)l2);
                jobTrace.debug("RowCount: " + sBFM.rowCount + "Length of tablDataBlock: " + l2);
                short s = (short)this.RPCPPopInt16("return Status for job_getColumnInfoArray");
                if (s < 0) {
                    throw this.raiseException(s);
                }
                byte[] byArray = this.mem;
                return byArray;
            }
            catch (rpcException rpcException2) {
                throw new SQLException(rpcException2.getMessage(), "08S01");
            }
        }
    }

    public byte[] job_getNewBlock(SBFM sBFM, long l, int n) throws SQLException {
        Packet packet = this.packet;
        synchronized (packet) {
            jobTrace.println("Call job_getNewBlock" + n);
            this.RPCStartOFrame();
            this.RPCPushStringNoNull(this.RPC_EXEC_FUNC, "<RPC_EXEC_FUNC>");
            this.RPCPushInt16((short)10, "<Ordinal>");
            this.RPCPushInt32(l, "hStmt");
            this.RPCPushInt16((short)n, "nextColumn");
            this.RPCPushInt32(4000L, "MAXDATALEN for [out] string startPositions");
            this.RPCPushInt32(4000L, "MAXDATALEN for [out] string tableData ");
            this.RPCPushInt32(4000L, "MAXDATALEN for [out] string wasNull ");
            this.RPCPostFrame();
            try {
                this.RPCStartIFrame();
                int n2 = this.RPCPPopInt16("ordinal");
                sBFM.readColumn = this.RPCPPopInt16("readColumn");
                long l2 = this.RPCPPopInt32("MAXDATALEN");
                sBFM.startPositionsBlock = this.packet.readLenMemory((int)l2);
                sBFM.rowCount = (int)(l2 / 4L);
                l2 = this.RPCPPopInt32("MAXDATALEN");
                sBFM.tableDataBlock = this.packet.readLenMemory((int)l2);
                jobTrace.debug("RowCount: " + sBFM.rowCount + "Length of tablDataBlock: " + l2);
                l2 = this.RPCPPopInt32("MAXDATALEN");
                jobTrace.debug("Length of wasNullsarray: " + l2);
                sBFM.wasNulls = this.packet.readLenMemory((int)l2);
                short s = (short)this.RPCPPopInt16("return Status for job_getNewBlock");
                if (s < 0) {
                    throw this.raiseException(s);
                }
                byte[] byArray = this.mem;
                return byArray;
            }
            catch (rpcException rpcException2) {
                throw new SQLException(rpcException2.getMessage(), "08S01");
            }
        }
    }

    public Object[] getDataXLOK(long l, int n, short s, long l2) throws SQLException {
        Packet packet = this.packet;
        synchronized (packet) {
            this.packet.clear();
            this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
            this.packet.write2Bytes(4);
            this.packet.pushInt32(l);
            this.packet.write2Bytes(n);
            this.packet.write2Bytes(s);
            this.RPCPushInt32(l2, "MAXDATALEN for [out] string value");
            this.RPCPushInt32(l2, "MAXDATALEN for [out] string value");
            this.packet.send();
            try {
                Object[] objectArray;
                this.packet.next();
                this.packet.readByte();
                int n2 = this.packet.read2Bytes();
                long l3 = this.packet.read4Bytes();
                this.mem = this.packet.readLenMemory((int)l3);
                long l4 = this.packet.read4Bytes();
                short s2 = (short)this.packet.read2Bytes();
                if (s2 < 0) {
                    throw this.raiseException(s2);
                }
                Object[] objectArray2 = objectArray = new Object[]{this.mem, new Long(l4)};
                return objectArray2;
            }
            catch (rpcException rpcException2) {
                throw new SQLException(rpcException2.getMessage(), "08S01");
            }
        }
    }

    public String getURL() {
        return "jdbc:easysoft://" + this.host + ":" + this.port + "/" + this.dsn;
    }

    public void ImportFunc() {
        String string = "";
        jobTrace.debug("Client: importing functions");
        try {
            this.data = this.packet.readPacket();
            jobTrace.debug("Start func " + this.data);
            String string2 = "";
            if (this.RPC_STARTFUNC.equals(this.data)) {
                this.data = this.packet.readPacket();
                while (!this.RPC_ENDFUNC.equals(this.data)) {
                    Function function = new Function(this.data);
                    this.functionTable.put(function.name(), function);
                    if (this.generateStub) {
                        string = string + function.toStub(true);
                    }
                    this.data = this.packet.readPacket();
                }
                if (this.generateStub) {
                    Client.dumpCode("Stub.java", string);
                }
            } else {
                jobTrace.debug("error" + this.RPC_STARTFUNC);
                System.exit(0);
            }
        }
        catch (Exception exception) {
            jobTrace.debug(exception.getMessage());
        }
    }

    public boolean int2bool(int n) {
        return n == 0;
    }

    public void LogTrcMsgStr(String string) {
        if (this.TRACING) {
            this.traceMessage = this.traceMessage + string;
        }
    }

    public void LogTrcMsgStrln(String string) {
        if (this.TRACING) {
            DriverManager.println(this.traceMessage + string);
            this.traceMessage = "";
        }
    }

    public void Trace(String string, String string2, Object[] objectArray) {
        if (this.TRACING) {
            jobTrace.print("*" + string + "." + string2 + " (");
            int n = 0;
            while (n < objectArray.length) {
                if (n == objectArray.length - 1) {
                    jobTrace.print(objectArray[n] + "");
                } else {
                    jobTrace.print(objectArray[n] + ", ");
                }
                ++n;
            }
            jobTrace.println(")");
        }
    }

    public Object Return(String string, Object object) {
        if (this.TRACING) {
            jobTrace.println(string + " returning = " + object);
        }
        return object;
    }

    public void negotiate() throws rpcException, SQLException {
        Object object;
        try {
            this.packet.next();
        }
        catch (Exception exception) {
            if (this.s.getPort() == 8031) {
                throw new rpcException(exception.getMessage() + "\nPort " + this.s.getPort() + " is not the port for the JOB server: Please check the port and try");
            }
            throw new rpcException(exception.getMessage());
        }
        try {
            this.data = this.packet.readLenString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        jobTrace.debug("Magic number: " + this.data);
        this.packet.next();
        try {
            this.data = this.packet.readLenString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        jobTrace.debug("Version: " + this.data);
        String string = this.data.substring(4, 8);
        jobTrace.debug("bit " + string);
        if ((string.equals("2001") || string.equals("2002")) && !jobTrace.clearText) {
            this.encryption = true;
        }
        this.packet.next();
        try {
            this.data = this.packet.readLenString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        jobTrace.debug("receives the parameter string: " + this.data);
        jobTrace.debug(this.data + this.data.indexOf("AIX") + "Index: " + this.data.indexOf("SunOS"));
        boolean bl = false;
        int n = this.data.indexOf("6:");
        boolean bl2 = false;
        try {
            object = System.getProperty("java.vendor");
            if (object != null && ((String)object).charAt(0) == 'M') {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        if (bl2) {
            object = this.data.getBytes();
            bl = object[n + 2] != 63;
        } else {
            try {
                object = this.data.getBytes("US-ASCII");
                bl = object[n + 2] != 63;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            catch (Exception exception) {
                byte[] byArray = this.data.getBytes();
                bl = byArray[n + 2] != 63;
            }
        }
        this.packet.clear();
        object = "01:Linux^02:2.0.33^03:i686^04:4^05:^";
        this.packet.writeString((String)object);
        this.packet.send();
        jobTrace.debug("Sent Parameter String: " + (String)object);
        this.ImportFunc();
        this.packet.swapBytes = bl;
    }

    void RPCPostFrame() throws SQLException {
        this.packet.send();
    }

    int RPCPPopInt16(String string) {
        int n = this.packet.read2Bytes();
        return n;
    }

    long RPCPPopInt32(String string) {
        long l = this.packet.read4Bytes();
        return l;
    }

    void RPCPushInt16(short s, String string) {
        this.packet.write2Bytes(s);
    }

    void RPCPushInt32(long l, String string) {
        this.packet.pushInt32(l);
    }

    void RPCPushString(String string, String string2) {
        this.packet.writeString(string);
    }

    void RPCPushStringNoNull(String string, String string2) {
        this.packet.writeStringNoNull(string);
    }

    void RPCStartIFrame() throws rpcException, SQLException {
        this.packet.next();
        byte by = this.packet.readByte();
        if (by != this.RPC_START_IFRAME) {
            throw new rpcException("RPC_ERROR_BAD_START");
        }
    }

    void RPCStartOFrame() {
        this.packet.clear();
    }

    public void runClient() {
    }

    public void setBytes(long l, short s, byte[] byArray) throws SQLException {
        this.packet.clear();
        this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
        this.packet.write2Bytes(5);
        this.packet.pushInt32(l);
        this.packet.write2Bytes(s);
        this.packet.sendByteArray(byArray);
        this.packet.send();
        try {
            this.packet.next();
            this.packet.readByte();
            int n = this.packet.read2Bytes();
            short s2 = (short)this.packet.read2Bytes();
            if (s2 < 0) {
                throw this.raiseException(s2);
            }
        }
        catch (Exception exception) {
            jobTrace.error(exception.getMessage());
        }
    }

    byte[] mygetBytes(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        int n = 0;
        while (n < byArray.length) {
            byArray2[n] = byArray[n];
            ++n;
        }
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    public void setLOB(long l, short s, byte[] byArray, int n) throws SQLException {
        this.packet.clear();
        this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
        this.packet.write2Bytes(6);
        this.packet.pushInt32(l);
        this.packet.write2Bytes(s);
        this.packet.write2Bytes((short)n);
        this.packet.sendByteArray(byArray);
        this.packet.send();
        try {
            this.packet.next();
            this.packet.readByte();
            int n2 = this.packet.read2Bytes();
            short s2 = (short)this.packet.read2Bytes();
            if (s2 < 0) {
                throw this.raiseException(s2);
            }
        }
        catch (Exception exception) {
            jobTrace.debug(exception.getMessage());
        }
    }

    public void shipLengths(long l, int[] nArray, int n) throws SQLException {
        byte[] byArray = new byte[4 * n];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            byArray = this.packet.write4Bytes(nArray[n2], n2 * 4, byArray);
            ++n2;
        }
        this.packet.clear();
        this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
        this.packet.write2Bytes(13);
        this.packet.pushInt32(l);
        this.packet.sendByteArray(byArray);
        this.packet.send();
        try {
            this.packet.next();
            this.packet.readByte();
            int n3 = this.packet.read2Bytes();
            short s = (short)this.packet.read2Bytes();
            if (s < 0) {
                throw this.raiseException(s);
            }
        }
        catch (rpcException rpcException2) {
            throw new SQLException(rpcException2.getMessage(), "08S01");
        }
    }

    public void job_pset_one_go(long l, byte[] byArray, int n) throws SQLException {
        jobTrace.debug("Call job_pset_one_go");
        this.packet.clear();
        this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
        this.packet.write2Bytes(15);
        this.packet.pushInt32(l);
        this.packet.sendByteArray(byArray, n);
        this.packet.send();
        try {
            this.packet.next();
            this.packet.readByte();
            int n2 = this.packet.read2Bytes();
            short s = (short)this.packet.read2Bytes();
            if (s < 0) {
                throw this.raiseException(s);
            }
        }
        catch (rpcException rpcException2) {
            throw new SQLException(rpcException2.getMessage(), "08S01");
        }
    }

    public void job_ucs_one_go(long l, byte[] byArray, int n) throws SQLException {
        jobTrace.debug("Call job_ucs_one_go");
        this.packet.clear();
        this.packet.writeStringNoNull(this.RPC_EXEC_FUNC);
        this.packet.write2Bytes(16);
        this.packet.pushInt32(l);
        this.packet.sendByteArray(byArray, n);
        this.packet.send();
        try {
            this.packet.next();
            this.packet.readByte();
            int n2 = this.packet.read2Bytes();
            short s = (short)this.packet.read2Bytes();
            if (s < 0) {
                throw this.raiseException(s);
            }
        }
        catch (rpcException rpcException2) {
            throw new SQLException(rpcException2.getMessage(), "08S01");
        }
    }

    public void stop() throws SQLException {
        try {
            this.s.close();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage(), "08S01");
        }
    }

    public String faze(String string, boolean bl) throws SQLException {
        Random random = new Random();
        int n = 1;
        int n2 = 0;
        jobTrace.debug("DEFAULT ENCODING is: " + this.getDefaultEncoding());
        if (!this.encryption) {
            return string;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = bl ? new byte[byArray.length * 2] : new byte[byArray.length / 2];
        jobTrace.debug("faze(" + string + ")");
        int n3 = 0;
        while (n3 < byArray.length) {
            jobTrace.debug("in[" + n3 + "]=" + byArray[n3] + " a=" + n);
            byArray2[n2] = (byte)(byArray[n3] ^ n);
            if (byArray2[n2] == 0) {
                byArray2[n2] = byArray[n3];
            }
            jobTrace.debug("out[" + n2 + "]=" + byArray2[n2]);
            ++n2;
            if (bl) {
                int n4 = random.nextInt() % 120;
                byte by = (byte)((byte)n4 - 1);
                if (by < 0) {
                    by = (byte)(-1 * by);
                }
                by = (byte)(by + 1);
                jobTrace.debug("RAND: " + n4 + "BYTE " + by);
                byArray2[n2] = by;
                ++n2;
            } else {
                ++n3;
            }
            n = (byte)(n << 1);
            if (n == -128) {
                n = 1;
            }
            ++n3;
        }
        String string2 = this.byteArray2StringISO(byArray2);
        if (bl) {
            string2 = "XX" + string2;
        }
        return string2;
    }

    public String byteArray2StringISO(byte[] byArray) throws SQLException {
        try {
            jobTrace.debug("Using ISO8859_1");
            return new String(byArray, "ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public String getDefaultEncoding() {
        byte[] byArray = new byte[2];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        return inputStreamReader.getEncoding();
    }
}

