/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.NullObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class ObjectTranslator {
    public static Object translate(Object object) {
        if (object == null || object instanceof NullObject || object instanceof String || object instanceof BigDecimal || object instanceof Date || object instanceof ByteLongObject || object instanceof Boolean) {
            return object;
        }
        if (object instanceof byte[]) {
            return new ByteLongObject((byte[])object);
        }
        if (object instanceof Serializable) {
            return ObjectTranslator.serialize(object);
        }
        throw new Error("Unable to translate object.  It is not a primitive type or serializable.");
    }

    public static ByteLongObject serialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return new ByteLongObject(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new Error("Serialization error: " + iOException.getMessage());
        }
    }

    public static Object deserialize(ByteLongObject byteLongObject) {
        if (byteLongObject == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteLongObject.getByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Class not found: " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("De-serialization error: " + iOException.getMessage());
        }
    }
}

