/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

class MBlob
implements Blob {
    private ByteLongObject blob;

    MBlob(ByteLongObject byteLongObject) {
        this.blob = byteLongObject;
    }

    public long length() throws SQLException {
        return this.blob.length();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (--l < 0L || l + (long)n > this.length()) {
            throw new SQLException("Out of bounds.");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.blob.getByteArray(), (int)l, byArray, 0, n);
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.blob.getByteArray(), 0, (int)this.length());
    }

    public long position(byte[] byArray, long l) throws SQLException {
        byte[] byArray2 = this.blob.getByteArray();
        int n = (int)this.length();
        int n2 = (int)this.length() - byArray.length;
        int n3 = (int)(l - 1L);
        while (true) {
            if (n3 <= n2 && byArray2[n3] != byArray[0]) {
                ++n3;
                continue;
            }
            if (n3 > n2) {
                return -1L;
            }
            int n4 = n3;
            int n5 = 1;
            while (n5 < byArray.length && byArray2[n4] == byArray[n5]) {
                ++n4;
                ++n5;
            }
            ++n3;
            if (n5 >= byArray.length) break;
        }
        return n3;
    }

    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = blob instanceof MBlob ? ((MBlob)blob).blob.getByteArray() : blob.getBytes(0L, (int)blob.length());
        return this.position(byArray, l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }

    public void truncate(long l) throws SQLException {
        throw new SQLException("BLOB updating is not supported");
    }
}

