/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.MDatabaseMetaData;
import com.mckoi.database.jdbc.MPreparedStatement;
import com.mckoi.database.jdbc.MResultSet;
import com.mckoi.database.jdbc.MStatement;
import com.mckoi.database.jdbc.MckoiConnection;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.database.jdbc.RowCache;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbc.TriggerListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class MConnection
implements Connection,
DatabaseCallBack {
    private RowCache row_cache;
    private String url;
    private SQLWarning head_warning;
    private boolean is_closed;
    private boolean auto_commit;
    private DatabaseInterface db_interface;
    private Vector trigger_list;
    private TriggerDispatchThread trigger_thread;
    private boolean strict_get_object;
    private boolean verbose_column_names;
    private boolean case_insensitive_identifiers;
    private Object lock = new Object();

    public MConnection(String string, DatabaseInterface databaseInterface, int n, int n2) {
        this.url = string;
        this.db_interface = databaseInterface;
        this.is_closed = true;
        this.auto_commit = true;
        this.trigger_list = new Vector();
        this.strict_get_object = true;
        this.verbose_column_names = false;
        this.case_insensitive_identifiers = false;
        this.row_cache = new RowCache(n, n2);
    }

    public void setStrictGetObject(boolean bl) {
        this.strict_get_object = bl;
    }

    public boolean isStrictGetObject() {
        return this.strict_get_object;
    }

    public void setVerboseColumnNames(boolean bl) {
        this.verbose_column_names = bl;
    }

    public boolean verboseColumnNames() {
        return this.verbose_column_names;
    }

    public void setCaseInsensitiveIdentifiers(boolean bl) {
        this.case_insensitive_identifiers = bl;
    }

    public boolean isCaseInsensitiveIdentifiers() {
        return this.case_insensitive_identifiers;
    }

    protected final RowCache getRowCache() {
        return this.row_cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSQLWarning(SQLWarning sQLWarning) {
        Object object = this.lock;
        synchronized (object) {
            if (this.head_warning == null) {
                this.head_warning = sQLWarning;
            } else {
                this.head_warning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void internalClose() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                try {
                    this.db_interface.dispose();
                    Object var3_2 = null;
                    this.is_closed = true;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.is_closed = true;
                    throw throwable;
                }
            }
        }
    }

    MckoiConnection getMckoiConnection() {
        return new MckoiConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String string, String string2, String string3) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.is_closed) {
                throw new SQLException("Unable to login to connection because it is open.");
            }
        }
        if (string == null) {
            string = "APP";
        }
        if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
            throw new SQLException("username or password have not been set.");
        }
        boolean bl = this.db_interface.login(string, string2, string3, this);
        Object object2 = this.lock;
        synchronized (object2) {
            this.is_closed = !bl;
        }
        if (!bl) {
            throw new SQLException("User authentication failed for: " + string2);
        }
        this.setCaseInsensitiveIdentifiers(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SHOW CONNECTION_INFO");
        while (resultSet.next()) {
            String string4;
            String string5 = resultSet.getString(1);
            if (string5.equals("case_insensitive_identifiers")) {
                string4 = resultSet.getString(2);
                this.setCaseInsensitiveIdentifiers(string4.equals("true"));
                continue;
            }
            if (!string5.equals("auto_commit")) continue;
            string4 = resultSet.getString(2);
            this.auto_commit = string4.equals("true");
        }
        resultSet.close();
        statement.close();
    }

    String getURL() {
        return this.url;
    }

    void login(Properties properties, String string) throws SQLException {
        String string2 = properties.getProperty("user", "");
        String string3 = properties.getProperty("password", "");
        this.login(string, string2, string3);
    }

    void executeQuery(SQLQuery sQLQuery, MResultSet mResultSet) throws SQLException {
        QueryResponse queryResponse = this.db_interface.execQuery(sQLQuery);
        ColumnDescription[] columnDescriptionArray = new ColumnDescription[queryResponse.getColumnCount()];
        int n = 0;
        while (n < columnDescriptionArray.length) {
            columnDescriptionArray[n] = queryResponse.getColumnDescription(n);
            ++n;
        }
        mResultSet.connSetup(queryResponse.getResultID(), columnDescriptionArray, queryResponse.getRowCount());
        mResultSet.setQueryTime(queryResponse.getQueryTimeMillis());
    }

    ResultPart requestResultPart(int n, int n2, int n3) throws SQLException {
        return this.db_interface.getResultPart(n, n2, n3);
    }

    void disposeResult(int n) throws SQLException {
        if (!this.is_closed) {
            this.db_interface.disposeResult(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTriggerListener(String string, TriggerListener triggerListener) {
        Vector vector = this.trigger_list;
        synchronized (vector) {
            this.trigger_list.addElement(string);
            this.trigger_list.addElement(triggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTriggerListener(String string, TriggerListener triggerListener) {
        Vector vector = this.trigger_list;
        synchronized (vector) {
            int n = this.trigger_list.size() - 2;
            while (n >= 0) {
                if (this.trigger_list.elementAt(n).equals(string) && this.trigger_list.elementAt(n + 1).equals(triggerListener)) {
                    this.trigger_list.removeElementAt(n);
                    this.trigger_list.removeElementAt(n);
                }
                n -= 2;
            }
        }
    }

    public void databaseEvent(int n, String string) {
        if (n == 99) {
            if (this.trigger_thread == null) {
                this.trigger_thread = new TriggerDispatchThread();
                this.trigger_thread.start();
            }
        } else {
            throw new Error("Unrecognised database event: " + n);
        }
        this.trigger_thread.dispatchTrigger(string);
    }

    public Statement createStatement() throws SQLException {
        return new MStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new MPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("CallableStatement not supported.");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (bl) {
            ResultSet resultSet = this.createStatement().executeQuery("SET AUTO COMMIT ON");
            this.auto_commit = true;
            resultSet.close();
        } else {
            ResultSet resultSet = this.createStatement().executeQuery("SET AUTO COMMIT OFF");
            this.auto_commit = false;
            resultSet.close();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.auto_commit;
    }

    public void commit() throws SQLException {
        ResultSet resultSet = this.createStatement().executeQuery("COMMIT");
        resultSet.close();
    }

    public void rollback() throws SQLException {
        ResultSet resultSet = this.createStatement().executeQuery("ROLLBACK");
        resultSet.close();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.internalClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.is_closed;
            return bl;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new MDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 8) {
            throw new SQLException("Only 'TRANSACTION_SERIALIZABLE' supported.");
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            SQLWarning sQLWarning = this.head_warning;
            return sQLWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.head_warning = null;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = this.createStatement();
        return statement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("CallableStatement not supported.");
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not supported.");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not supported.");
    }

    public void setHoldability(int n) throws SQLException {
        if (n == 2) {
            throw new SQLException("CLOSE_CURSORS_AT_COMMIT holdability is not supported.");
        }
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("CLOSE_CURSORS_AT_COMMIT holdability is not supported.");
        }
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("CLOSE_CURSORS_AT_COMMIT holdability is not supported.");
        }
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    private class TriggerDispatchThread
    extends Thread {
        private Vector trigger_messages_queue = new Vector();

        TriggerDispatchThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchTrigger(String string) {
            Vector vector = this.trigger_messages_queue;
            synchronized (vector) {
                this.trigger_messages_queue.addElement(string);
                this.trigger_messages_queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    block9: while (true) {
                        Object object;
                        int n;
                        String string;
                        Vector vector = this.trigger_messages_queue;
                        synchronized (vector) {
                            while (this.trigger_messages_queue.size() == 0) {
                                try {
                                    this.trigger_messages_queue.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            string = (String)this.trigger_messages_queue.elementAt(0);
                            this.trigger_messages_queue.removeElementAt(0);
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                        String string2 = (String)stringTokenizer.nextElement();
                        String string3 = (String)stringTokenizer.nextElement();
                        String string4 = (String)stringTokenizer.nextElement();
                        Vector<TriggerListener> vector2 = new Vector<TriggerListener>();
                        Vector vector3 = MConnection.this.trigger_list;
                        synchronized (vector3) {
                            n = 0;
                            while (n < MConnection.this.trigger_list.size()) {
                                object = (String)MConnection.this.trigger_list.elementAt(n);
                                if (((String)object).equals(string2)) {
                                    TriggerListener triggerListener = (TriggerListener)MConnection.this.trigger_list.elementAt(n + 1);
                                    vector2.addElement(triggerListener);
                                }
                                n += 2;
                            }
                        }
                        n = 0;
                        while (true) {
                            if (n >= vector2.size()) continue block9;
                            object = (TriggerListener)vector2.elementAt(n);
                            object.triggerFired(string2);
                            ++n;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

