/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MResultSet;
import com.mckoi.database.jdbc.MStatement;
import com.mckoi.database.jdbc.SQLQuery;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class MPreparedStatement
extends MStatement
implements PreparedStatement {
    private SQLQuery statement;

    MPreparedStatement(MConnection mConnection, String string) {
        super(mConnection);
        this.statement = new SQLQuery(string);
    }

    Object convertToType(Object object, int n) throws SQLException {
        return object;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.statement);
    }

    public int executeUpdate() throws SQLException {
        MResultSet mResultSet = this.executeQuery(this.statement);
        return mResultSet.intValue();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.statement.setVar(n - 1, null);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.statement.setVar(n - 1, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setLong(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setLong(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setLong(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.statement.setVar(n - 1, BigDecimal.valueOf(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.statement.setVar(n - 1, new BigDecimal(Float.toString(f)));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.statement.setVar(n - 1, new BigDecimal(Double.toString(d)));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.statement.setVar(n - 1, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.statement.setVar(n - 1, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        ByteLongObject byteLongObject = new ByteLongObject(byArray);
        this.statement.setVar(n - 1, byteLongObject);
    }

    public void extSetDate(int n, java.util.Date date) throws SQLException {
        this.statement.setVar(n - 1, date);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.extSetDate(n, new java.util.Date(date.getTime()));
    }

    public void setTime(int n, Time time) throws SQLException {
        this.extSetDate(n, new java.util.Date(time.getTime()));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        long l = timestamp.getTime() + (long)(timestamp.getNanos() / 1000000);
        this.extSetDate(n, new java.util.Date(l));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = inputStream.read();
                if (n4 == -1) {
                    throw new IOException("End of stream reached before length reached.");
                }
                stringBuffer.append((char)n4);
                ++n3;
            }
            this.setString(n, new String(stringBuffer));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException("IO Error: " + iOException.getMessage());
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Deprecated method not supported");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            ByteLongObject byteLongObject = new ByteLongObject(inputStream, n2);
            this.statement.setVar(n - 1, byteLongObject);
        }
        catch (IOException iOException) {
            throw new SQLException("IOException reading input stream: " + iOException.getMessage());
        }
    }

    public void clearParameters() throws SQLException {
        this.statement.clear();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if ((object = this.convertToType(object, n2)) instanceof BigDecimal) {
            object = ((BigDecimal)object).setScale(n3, 4);
        }
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        object = this.convertToType(object, n2);
        this.setObject(n, object);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.statement.setVar(n - 1, object);
    }

    public boolean execute() throws SQLException {
        MResultSet mResultSet = this.executeQuery(this.statement);
        return !mResultSet.isUpdate();
    }

    public void addBatch() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        try {
            while (n2 > 0) {
                int n3 = reader.read(cArray, 0, Math.min(1024, n2));
                if (n3 > 0) {
                    stringBuffer.append(cArray, 0, n3);
                    n2 -= n3;
                    continue;
                }
                throw new SQLException("Premature end of Reader reached.");
            }
        }
        catch (IOException iOException) {
            throw new SQLException("IOError: " + iOException.getMessage());
        }
        this.setString(n, new String(stringBuffer));
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        long l = blob.length();
        if (l > Integer.MIN_VALUE) {
            throw new SQLException("BLOB > 2 gigabytes is too large.");
        }
        this.setBinaryStream(n, blob.getBinaryStream(), (int)l);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        long l = clob.length();
        if (l > Integer.MIN_VALUE) {
            throw new SQLException("CLOB > 2 gigabytes is too large.");
        }
        this.setString(n, clob.getSubString(0L, (int)l));
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public String toString() {
        return this.statement.toString();
    }
}

