/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.debug;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public final class Debug {
    private static final boolean PRINT_ALERT_TO_MESSAGES = false;
    private static final boolean EXCEPTIONS_TO_ERR = false;
    public static final int INFORMATION = 10;
    public static final int WARNING = 20;
    public static final int ALERT = 30;
    public static final int ERROR = 40;
    public static final int MESSAGE = 10000;
    private static final Object debug_lock = new Object();
    static final PrintWriter SYSTEM_OUT = new PrintWriter(System.out, true);
    static final PrintWriter SYSTEM_ERR = new PrintWriter(System.err, true);
    static int debug_level = 0;
    static PrintWriter out = SYSTEM_ERR;
    static PrintWriter err = SYSTEM_ERR;

    private static final void internalWrite(PrintWriter printWriter, int n, String string, String string2) {
        if (n < 10000) {
            printWriter.print("> ");
            printWriter.print(string);
            printWriter.print(" ( lvl: ");
            printWriter.print(n);
            printWriter.print(" )\n  ");
        } else {
            printWriter.print("% ");
        }
        printWriter.println(string2);
        printWriter.flush();
    }

    public static final void setOutput(Writer writer) {
        out = new PrintWriter(writer, false);
    }

    public static final void setDebugLevel(int n) {
        debug_level = n;
    }

    public static final void listenToEventDispatcher() {
        System.setProperty("sun.awt.exception.handler", "com.mckoi.debug.DispatchNotify");
    }

    public static final boolean isInterestedIn(int n) {
        return n >= debug_level;
    }

    public static final void write(int n, Object object, String string) {
        Debug.write(n, object.getClass().getName(), string);
    }

    public static final void write(int n, Class clazz, String string) {
        Debug.write(n, clazz.getName(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(int n, String string, String string2) {
        if (Debug.isInterestedIn(n)) {
            Object object = debug_lock;
            synchronized (object) {
                if (n >= 40 && n < 10000) {
                    Debug.internalWrite(SYSTEM_ERR, n, string, string2);
                }
                Debug.internalWrite(out, n, string, string2);
            }
        }
    }

    public static final void write(Object object, String string) {
        Debug.write(5, object, string);
    }

    private static final void writeTime() {
        out.print("[ TIME: ");
        out.print(new Date(System.currentTimeMillis()));
        out.println(" ]");
        out.flush();
    }

    public static final void writeException(Throwable throwable) {
        Debug.writeException(40, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeException(int n, Throwable throwable) {
        Object object = debug_lock;
        synchronized (object) {
            if (n >= 40) {
                System.err.print("[com.mckoi.debug.Debug - Exception thrown: '");
                System.err.print(throwable.getMessage());
                System.err.println("']");
                throwable.printStackTrace(System.err);
            }
            if (Debug.isInterestedIn(n)) {
                Debug.writeTime();
                out.print("% ");
                throwable.printStackTrace(out);
                out.flush();
            }
        }
    }
}

