/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.control;

import com.mckoi.database.control.AbstractDBConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultDBConfig
extends AbstractDBConfig {
    private static Hashtable CONFIG_DEFAULTS = new Hashtable();

    public DefaultDBConfig(File file) {
        super(file);
    }

    public DefaultDBConfig() {
        this(new File("."));
    }

    protected String getDefaultValue(String string) {
        ConfigProperty configProperty = (ConfigProperty)CONFIG_DEFAULTS.get(string);
        if (configProperty == null) {
            return null;
        }
        return configProperty.getDefaultValue();
    }

    public void setValue(String string, String string2) {
        super.setValue(string, string2);
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(inputStream));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setValue(string, properties.getProperty(string));
        }
    }

    public void loadFromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.loadFromStream(fileInputStream);
        fileInputStream.close();
    }

    public void loadFromURL(URL uRL) throws IOException {
        InputStream inputStream = uRL.openConnection().getInputStream();
        this.loadFromStream(inputStream);
        inputStream.close();
    }

    public void setDatabasePath(String string) {
        this.setValue("database_path", string);
    }

    public void setLogPath(String string) {
        this.setValue("log_path", string);
    }

    public void setIgnoreIdentifierCase(boolean bl) {
        this.setValue("ignore_case_for_identifiers", bl ? "enabled" : "disabled");
    }

    public void setReadOnly(boolean bl) {
        this.setValue("read_only", bl ? "enabled" : "disabled");
    }

    public void setMinimumDebugLevel(int n) {
        this.setValue("debug_level", "" + n);
    }

    private static void addDefProperty(ConfigProperty configProperty) {
        CONFIG_DEFAULTS.put(configProperty.getKey(), configProperty);
    }

    static {
        DefaultDBConfig.addDefProperty(new ConfigProperty("database_path", "./data", "PATH"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("log_path", "./log", "PATH"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("root_path", "jvm", "STRING"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("jdbc_server_port", "9157", "STRING"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("ignore_case_for_identifiers", "disabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("regex_library", "gnu.regexp", "STRING"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("data_cache_size", "4194304", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("max_cache_entry_size", "8192", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("lookup_comparison_list", "enabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("maximum_worker_threads", "4", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("dont_synch_filesystem", "disabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("transaction_error_on_dirty_select", "enabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("read_only", "disabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("debug_log_file", "debug.log", "FILE"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("debug_level", "20", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("table_lock_check", "enabled", "BOOLEAN"));
    }

    private static class ConfigProperty {
        private String key;
        private String default_value;
        private String type;
        private String comment;

        ConfigProperty(String string, String string2, String string3, String string4) {
            this.key = string;
            this.default_value = string2;
            this.type = string3;
            this.comment = string4;
        }

        ConfigProperty(String string, String string2, String string3) {
            this(string, string2, string3, null);
        }

        String getKey() {
            return this.key;
        }

        String getDefaultValue() {
            return this.default_value;
        }

        String getType() {
            return this.type;
        }

        String getComment() {
            return this.comment;
        }
    }
}

