/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.TypeUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ColumnDescription
implements Serializable {
    private String name;
    private int type;
    private int size;
    private int scale = -1;
    private int sql_type = -9332;
    private boolean not_null;
    private boolean unique;
    private int unique_group;

    public ColumnDescription(String string, int n, int n2, boolean bl) {
        this.name = string;
        this.type = n;
        this.size = n2;
        this.not_null = bl;
        this.unique = false;
        this.unique_group = -1;
    }

    public ColumnDescription(String string, int n, boolean bl) {
        this(string, n, -1, bl);
    }

    public ColumnDescription(ColumnDescription columnDescription) {
        this(columnDescription.getName(), columnDescription.getType(), columnDescription.getSize(), columnDescription.isNotNull());
        if (columnDescription.isUnique()) {
            this.setUnique();
        }
        this.setUniqueGroup(columnDescription.getUniqueGroup());
        this.setScale(columnDescription.getScale());
        this.setSQLType(columnDescription.getSQLType());
    }

    public ColumnDescription(String string, ColumnDescription columnDescription) {
        this(string, columnDescription.getType(), columnDescription.getSize(), columnDescription.isNotNull());
        if (columnDescription.isUnique()) {
            this.setUnique();
        }
        this.setUniqueGroup(columnDescription.getUniqueGroup());
        this.setScale(columnDescription.getScale());
        this.setSQLType(columnDescription.getSQLType());
    }

    public void setUnique() {
        this.unique = true;
    }

    public void setUniqueGroup(int n) {
        this.unique_group = n;
    }

    public void setSQLType(int n) {
        this.sql_type = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNumericType() {
        return this.type == 2;
    }

    public int getSQLType() {
        if (this.sql_type == -9332) {
            if (this.type == 2) {
                return 2;
            }
            if (this.type == 1) {
                return -1;
            }
            if (this.type == 5) {
                return -7;
            }
            if (this.type == 3) {
                return 93;
            }
            if (this.type == 6) {
                return -4;
            }
            if (this.type == 7) {
                return 2000;
            }
            throw new Error("Unrecognised internal type.");
        }
        return this.sql_type;
    }

    public String getSQLTypeName() {
        int n = this.getSQLType();
        switch (n) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
        }
        return null;
    }

    public Class classType() {
        return TypeUtil.toClass(this.type);
    }

    public int getSize() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNotNull() {
        return this.not_null;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getUniqueGroup() {
        return this.unique_group;
    }

    public boolean isQuantifiable() {
        return this.type != 6 && this.type != 7;
    }

    public boolean equals(Object object) {
        ColumnDescription columnDescription = (ColumnDescription)object;
        return this.name.equals(columnDescription.name) && this.type == columnDescription.type && this.size == columnDescription.size && this.not_null == columnDescription.not_null && this.unique == columnDescription.unique && this.unique_group == columnDescription.unique_group;
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.type);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeBoolean(this.not_null);
        dataOutputStream.writeBoolean(this.unique);
        dataOutputStream.writeInt(this.unique_group);
        dataOutputStream.writeInt(this.sql_type);
        dataOutputStream.writeInt(this.scale);
    }

    public static ColumnDescription readFrom(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        boolean bl2 = dataInputStream.readBoolean();
        int n3 = dataInputStream.readInt();
        ColumnDescription columnDescription = new ColumnDescription(string, n, n2, bl);
        if (bl2) {
            columnDescription.setUnique();
        }
        columnDescription.setUniqueGroup(n3);
        columnDescription.setSQLType(dataInputStream.readInt());
        columnDescription.setScale(dataInputStream.readInt());
        return columnDescription;
    }
}

