/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MckoiConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MDatabaseMetaData
implements DatabaseMetaData {
    private MConnection connection;
    private String database_name;
    private String database_version;

    MDatabaseMetaData(MConnection mConnection) {
        this.connection = mConnection;
    }

    private void queryProductInformation() throws SQLException {
        if (this.database_name == null || this.database_version == null) {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SHOW PRODUCT");
            resultSet.next();
            this.database_name = resultSet.getString("name");
            this.database_version = resultSet.getString("version");
            statement.close();
            resultSet.close();
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT USER()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        statement.close();
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(" SELECT * FROM SYS_INFO.sUSRDatabaseStatistics   WHERE \"stat_name\" = 'DatabaseSystem.read_only' ");
        boolean bl = resultSet.next();
        resultSet.close();
        statement.close();
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        this.queryProductInformation();
        return this.database_name;
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.queryProductInformation();
        return this.database_version;
    }

    public String getDriverName() throws SQLException {
        return "Mckoi JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "0.70-beta";
    }

    public int getDriverMajorVersion() {
        return 0;
    }

    public int getDriverMinorVersion() {
        return 70;
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.getURL().toLowerCase().startsWith(":jdbc:mckoi:local://");
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "show";
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "Schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "Procedure";
    }

    public String getCatalogTerm() throws SQLException {
        return "Catalog";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 32768;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getMaxColumnsInSelect();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 1;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getMaxColumnsInSelect();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 4096;
    }

    public int getMaxConnections() throws SQLException {
        return 8000;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x1000000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 60000;
    }

    public int getMaxStatements() throws SQLException {
        return 1024;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 50;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 512;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 50;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_PROCEDURES ( ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_PROCEDURE_COLUMNS ( ?, ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string4);
        return preparedStatement.executeQuery();
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n;
        Object object;
        if (string3 == null) {
            string3 = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        String string4 = "";
        int n2 = 0;
        if (stringArray != null && stringArray.length > 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append("      AND \"sUSRTableInfo.type\" IN ( ");
            n = 0;
            while (n < stringArray.length - 1) {
                ((StringBuffer)object).append("?, ");
                ++n;
            }
            ((StringBuffer)object).append("? ) \n");
            n2 = stringArray.length;
            string4 = new String((StringBuffer)object);
        }
        object = this.connection.prepareStatement("   SELECT NULL AS \"TABLE_CAT\", \n          \"schema\" AS \"TABLE_SCHEM\", \n          \"name\" AS \"TABLE_NAME\", \n          \"type\" AS \"TABLE_TYPE\", \n          \"other\" AS \"REMARKS\" \n     FROM \"SYS_INFO.sUSRTableInfo\" \n    WHERE \"sUSRTableInfo.schema\" LIKE ? \n      AND \"sUSRTableInfo.name\" LIKE ? \n" + string4);
        object.setString(1, string2);
        object.setString(2, string3);
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                object.setString(3 + n, stringArray[n]);
                ++n;
            }
        }
        return object.executeQuery();
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery("    SELECT \"name\" AS \"TABLE_SCHEM\"       FROM SYS_INFO.sUSRSchemaInfo   ORDER BY \"TABLE_SCHEM\" ");
    }

    public ResultSet getCatalogs() throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery("SHOW JDBC_CATALOGS");
    }

    public ResultSet getTableTypes() throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery("SHOW JDBC_TABLE_TYPES");
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            string3 = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement("  SELECT NULL AS \"TABLE_CAT\",\n         \"schema\" AS \"TABLE_SCHEM\",\n         \"table\" AS \"TABLE_NAME\",\n         \"column\" AS \"COLUMN_NAME\",\n         \"sql_type\" AS \"DATA_TYPE\",\n         \"type_desc\" AS \"TYPE_NAME\",\n         IF(\"size\" = -1, 1024, \"size\") AS \"COLUMN_SIZE\",\n         NULL AS \"BUFFER_LENGTH\",\n         \"scale\" AS \"DECIMAL_DIGITS\",\n         IF(\"sql_type\" = -7, 2, 10) AS \"NUM_PREC_RADIX\",\n         IF(\"not_null\", 0, 1) AS \"NULLABLE\",\n         '' AS \"REMARKS\",\n         \"default\" AS \"COLUMN_DEF\",\n         NULL AS \"SQL_DATA_TYPE\",\n         NULL AS \"SQL_DATETIME_SUB\",\n         IF(\"size\" = -1, 1024, \"size\") AS \"CHAR_OCTET_LENGTH\",\n         \"seq_no\" + 1 AS \"ORDINAL_POSITION\",\n         IF(\"not_null\", 'NO', 'YES') AS \"IS_NULLABLE\"\n    FROM SYS_INFO.sUSRTableColumns\n   WHERE \"schema\" LIKE ?\n     AND \"table\" LIKE ?\n     AND \"column\" LIKE ?\nORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string4);
        return preparedStatement.executeQuery();
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_COLUMN_PRIVILEGES ( ?, ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string4);
        return preparedStatement.executeQuery();
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_TABLE_PRIVILEGES ( ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_BEST_ROW_IDENTIFIER ( ?, ?, ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setInt(4, n);
        preparedStatement.setBoolean(5, bl);
        return preparedStatement.executeQuery();
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_VERSION_COLUMNS ( ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("  SELECT NULL \"TABLE_CAT\",\n         \"schema\" \"TABLE_SCHEM\",\n         \"table\" \"TABLE_NAME\",\n         \"column\" \"COLUMN_NAME\",\n         \"seq_no\" \"SEQ_NO\",\n         \"name\" \"PK_NAME\"\n    FROM SYS_INFO.sUSRPKeyInfo, SYS_INFO.sUSRPrimaryColumns\n   WHERE sUSRPKeyInfo.id = sUSRPrimaryColumns.pk_id\n     AND ( ? IS NULL OR \"schema\" = ? )\n     AND \"table\" = ?\nORDER BY \"COLUMN_NAME\"\n");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("  SELECT NULL \"PKTABLE_CAT\",\n         \"sUSRFKeyInfo.ref_schema\" \"PKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.ref_table\" \"PKTABLE_NAME\",\n         \"sUSRForeignColumns.pcolumn\" \"PKCOLUMN_NAME\",\n         NULL \"FKTABLE_CAT\",\n         \"sUSRFKeyInfo.schema\" \"FKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.table\" \"FKTABLE_NAME\",\n         \"sUSRForeignColumns.fcolumn\" \"FKCOLUMN_NAME\",\n         \"sUSRForeignColumns.seq_no\" \"KEY_SEQ\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.update_rule\") \"UPDATE_RULE\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.delete_rule\") \"DELETE_RULE\",\n         \"sUSRFKeyInfo.name\" \"FK_NAME\",\n         NULL \"PK_NAME\",\n         \"sUSRFKeyInfo.deferred\" \"DEFERRABILITY\"\n    FROM \"SYS_INFO.sUSRFKeyInfo\",\n         \"SYS_INFO.sUSRForeignColumns\"\n   WHERE ( ? IS NULL OR sUSRFKeyInfo.schema = ? )\n     AND sUSRFKeyInfo.table = ?\n     AND sUSRFKeyInfo.id = sUSRForeignColumns.fk_id\nORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"KEY_SEQ\"\n");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("  SELECT NULL \"PKTABLE_CAT\",\n         \"sUSRFKeyInfo.ref_schema\" \"PKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.ref_table\" \"PKTABLE_NAME\",\n         \"sUSRForeignColumns.pcolumn\" \"PKCOLUMN_NAME\",\n         NULL \"FKTABLE_CAT\",\n         \"sUSRFKeyInfo.schema\" \"FKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.table\" \"FKTABLE_NAME\",\n         \"sUSRForeignColumns.fcolumn\" \"FKCOLUMN_NAME\",\n         \"sUSRForeignColumns.seq_no\" \"KEY_SEQ\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.update_rule\") \"UPDATE_RULE\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.delete_rule\") \"DELETE_RULE\",\n         \"sUSRFKeyInfo.name\" \"FK_NAME\",\n         NULL \"PK_NAME\",\n         \"sUSRFKeyInfo.deferred\" \"DEFERRABILITY\"\n    FROM \"SYS_INFO.sUSRFKeyInfo\",\n         \"SYS_INFO.sUSRForeignColumns\"\n   WHERE ( ? IS NULL OR sUSRFKeyInfo.ref_schema = ? )\n     AND sUSRFKeyInfo.ref_table = ?\n     AND sUSRFKeyInfo.id = sUSRForeignColumns.fk_id\nORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"KEY_SEQ\"\n");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("  SELECT NULL \"PKTABLE_CAT\",\n         \"sUSRFKeyInfo.ref_schema\" \"PKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.ref_table\" \"PKTABLE_NAME\",\n         \"sUSRForeignColumns.pcolumn\" \"PKCOLUMN_NAME\",\n         NULL \"FKTABLE_CAT\",\n         \"sUSRFKeyInfo.schema\" \"FKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.table\" \"FKTABLE_NAME\",\n         \"sUSRForeignColumns.fcolumn\" \"FKCOLUMN_NAME\",\n         \"sUSRForeignColumns.seq_no\" \"KEY_SEQ\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.update_rule\") \"UPDATE_RULE\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.delete_rule\") \"DELETE_RULE\",\n         \"sUSRFKeyInfo.name\" \"FK_NAME\",\n         NULL \"PK_NAME\",\n         \"sUSRFKeyInfo.deferred\" \"DEFERRABILITY\"\n    FROM \"SYS_INFO.sUSRFKeyInfo\",\n         \"SYS_INFO.sUSRForeignColumns\"\n   WHERE ( ? IS NULL OR sUSRFKeyInfo.ref_schema = ? )\n     AND sUSRFKeyInfo.ref_table = ?\n     AND ( ? IS NULL OR sUSRFKeyInfo.schema = ? )\n     AND sUSRFKeyInfo.table = ?\n     AND sUSRFKeyInfo.id = sUSRForeignColumns.fk_id\nORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"KEY_SEQ\"\n");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string5);
        preparedStatement.setString(5, string5);
        preparedStatement.setString(6, string6);
        return preparedStatement.executeQuery();
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT * FROM SYS_INFO.sUSRSQLTypeInfo");
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_INDEX_INFO ( ?, ?, ?, ?, ? )");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setBoolean(5, bl2);
        return preparedStatement.executeQuery();
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003 || n == 1004;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n == 1004 && n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String string4 = "true";
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                String string5 = "JAVA_OBJECT";
                if (n2 == 2002) {
                    string5 = "STRUCT";
                } else if (n2 == 2001) {
                    string5 = "DISTINCT";
                }
                if (n != 0) {
                    string4 = string4 + " AND";
                }
                string4 = string4 + " DATA_TYPE = '" + MckoiConnection.quote(string5) + "'";
                ++n;
            }
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement("SHOW JDBC_UDTS ( ?, ?, ? ) WHERE " + string4);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        return preparedStatement.executeQuery();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int getDatabaseMinorVersion() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }
}

