/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.jdbc.MResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class MResultSetMetaData
implements ResultSetMetaData {
    private MResultSet result_set;

    MResultSetMetaData(MResultSet mResultSet) {
        this.result_set = mResultSet;
    }

    public int getColumnCount() throws SQLException {
        return this.result_set.columnCount();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        return this.result_set.getColumn(n - 1).isQuantifiable();
    }

    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        if (this.result_set.getColumn(n - 1).isNotNull()) {
            return 0;
        }
        return 1;
    }

    public boolean isSigned(int n) throws SQLException {
        return this.result_set.getColumn(n - 1).isNumericType();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return 64;
    }

    public String getColumnLabel(int n) throws SQLException {
        String string = this.result_set.getColumn(n - 1).getName();
        if (string.startsWith("@a")) {
            return string.substring(2);
        }
        if (string.startsWith("@f")) {
            int n2 = string.lastIndexOf(".");
            if (n2 > -1) {
                return string.substring(n2 + 1);
            }
            return string.substring(2);
        }
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        if (!this.result_set.verboseColumnNames()) {
            return this.getColumnLabel(n);
        }
        String string = this.result_set.getColumn(n - 1).getName();
        if (string.startsWith("@")) {
            return string.substring(2);
        }
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        ColumnDescription columnDescription = this.result_set.getColumn(n - 1);
        String string = columnDescription.getName();
        char c = 'f';
        int n2 = 0;
        if (string.startsWith("@")) {
            c = string.charAt(1);
            n2 = 2;
        }
        if (c == 'a') {
            return "";
        }
        if (c == 'f') {
            int n3 = string.lastIndexOf(".");
            if (n3 == -1) {
                return "";
            }
            if ((n3 = string.lastIndexOf(".", n3 - 1)) == -1) {
                return "";
            }
            int n4 = n3;
            if ((n3 = string.lastIndexOf(".", n3 - 1)) == -1) {
                return string.substring(n2, n4);
            }
            return string.substring(n3 + 1, n4);
        }
        throw new SQLException("Unknown column code: '" + c + "'");
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.result_set.getColumn(n - 1).getSize();
        if (n2 == -1) {
            n2 = 32;
        }
        return n2;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.result_set.getColumn(n - 1).getScale();
        if (n2 == -1) {
            n2 = 0;
        }
        return n2;
    }

    public String getTableName(int n) throws SQLException {
        ColumnDescription columnDescription = this.result_set.getColumn(n - 1);
        String string = columnDescription.getName();
        char c = 'f';
        int n2 = 0;
        if (string.startsWith("@")) {
            c = string.charAt(1);
            n2 = 2;
        }
        if (c == 'a') {
            return "";
        }
        if (c == 'f') {
            int n3 = string.lastIndexOf(".");
            if (n3 == -1) {
                return "";
            }
            int n4 = n3;
            if ((n3 = string.lastIndexOf(".", n4 - 1)) == -1) {
                return string.substring(n2, n4);
            }
            return string.substring(n3 + 1, n4);
        }
        throw new SQLException("Unknown column code: '" + c + "'");
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        return this.result_set.getColumn(n - 1).getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.result_set.getColumn(n - 1).getSQLTypeName();
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        return this.result_set.getColumn(n - 1).classType().toString();
    }
}

