/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MDriver;
import com.mckoi.database.jdbc.MResultSet;
import com.mckoi.database.jdbc.SQLQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

class MStatement
implements Statement {
    private MConnection connection;
    private MResultSet result_set;
    private int max_field_size;
    private int max_row_count;
    private int query_timeout;
    private int fetch_size;
    private SQLWarning head_warning;
    private boolean escape_processing;
    private int multi_result_set_index;

    MStatement(MConnection mConnection) {
        this.connection = mConnection;
        this.escape_processing = true;
    }

    final void addSQLWarning(SQLWarning sQLWarning) {
        if (this.head_warning == null) {
            this.head_warning = sQLWarning;
        } else {
            this.head_warning.setNextWarning(sQLWarning);
        }
    }

    final MResultSet internalResultSet() {
        if (this.result_set == null) {
            this.result_set = new MResultSet(this.connection, this);
        }
        return this.result_set;
    }

    protected MResultSet executeQuery(SQLQuery sQLQuery) throws SQLException {
        sQLQuery.prepare(this.escape_processing);
        MResultSet mResultSet = this.internalResultSet();
        this.multi_result_set_index = 0;
        mResultSet.closeCurrentResult();
        this.connection.executeQuery(sQLQuery, mResultSet);
        mResultSet.setFetchSize(this.fetch_size);
        mResultSet.setMaxRowCount(this.max_row_count);
        if (mResultSet.rowCount() < 40) {
            mResultSet.storeResultLocally();
        } else {
            mResultSet.updateResultPart(0, 10);
        }
        return mResultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(new SQLQuery(string));
    }

    public int executeUpdate(String string) throws SQLException {
        MResultSet mResultSet = this.executeQuery(new SQLQuery(string));
        return mResultSet.intValue();
    }

    public void close() throws SQLException {
        if (this.result_set != null) {
            this.internalResultSet().dispose();
            this.result_set = null;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("MaxFieldSize negative.");
        }
        this.max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.max_row_count;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("MaxRows negative.");
        }
        this.max_row_count = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escape_processing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.query_timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Negative query timout.");
        }
        this.query_timeout = n;
        MDriver.QUERY_TIMEOUT = n;
    }

    public void cancel() throws SQLException {
        this.connection.disposeResult(this.internalResultSet().getResultID());
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.head_warning;
    }

    public void clearWarnings() throws SQLException {
        this.head_warning = null;
    }

    public void setCursorName(String string) throws SQLException {
    }

    public boolean execute(String string) throws SQLException {
        MResultSet mResultSet = this.executeQuery(new SQLQuery(string));
        return !mResultSet.isUpdate();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.multi_result_set_index == 0) {
            return this.internalResultSet();
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        if (this.multi_result_set_index == 0 && this.internalResultSet().isUpdate()) {
            return this.internalResultSet().intValue();
        }
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        ++this.multi_result_set_index;
        return false;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Negative fetch size.");
        }
        this.fetch_size = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetch_size;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("Pending implementation.");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("Pending implementation.");
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("Pending implementation.");
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

