/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.jdbc.MSQLException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public final class SQLQuery {
    private String query;
    private boolean prepared;
    private Object[] parameters;
    private int parameters_index;
    private int parameter_count;

    public SQLQuery(String string) {
        this.query = string;
        this.parameters = new Object[8];
        this.parameters_index = 0;
        this.parameter_count = 0;
        this.prepared = false;
    }

    private void growParametersList(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.parameters, 0, objectArray, 0, this.parameters.length);
        this.parameters = objectArray;
    }

    private Object translateObjectType(Object object) {
        return ObjectTranslator.translate(object);
    }

    public void addVar(Object object) {
        this.parameters[this.parameters_index] = object = this.translateObjectType(object);
        ++this.parameters_index;
        ++this.parameter_count;
        if (this.parameters_index >= this.parameters.length) {
            this.growParametersList(this.parameters_index + 8);
        }
    }

    public void setVar(int n, Object object) {
        object = this.translateObjectType(object);
        if (n >= this.parameters.length) {
            this.growParametersList(n + 8);
        }
        this.parameters[n] = object;
        this.parameters_index = n + 1;
        this.parameter_count = Math.max(this.parameters_index, this.parameter_count);
    }

    public void clear() {
        this.parameters_index = 0;
        this.parameter_count = 0;
        int n = 0;
        while (n < this.parameters.length) {
            this.parameters[n] = null;
            ++n;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public Object[] getVars() {
        return this.parameters;
    }

    private String escapeJDBCSubstitution(String string) throws SQLException {
        String string2 = string.substring(1, string.length() - 1);
        int n = string2.indexOf(32);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n).trim();
            if (string3.equals("d")) {
                return "DATE " + string4;
            }
            if (string3.equals("t")) {
                return "TIME " + string4;
            }
            if (string3.equals("ts")) {
                return "TIMESTAMP " + string4;
            }
            if (string3.equals("fn")) {
                return string4;
            }
            if (string3.equals("call") || string3.equals("?=")) {
                throw new MSQLException("Stored procedures not supported.");
            }
            if (string3.equals("oj")) {
                return string4;
            }
            throw new MSQLException("Do not understand JDBC substitution keyword '" + string3 + "' of " + string);
        }
        throw new MSQLException("Malformed JDBC escape code: " + string);
    }

    private void doEscapeSubstitutions() throws SQLException {
        if (this.query.indexOf(123) == -1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n = 0;
        int n2 = this.query.length();
        int n3 = 0;
        boolean bl = false;
        while (n < n2) {
            char c = this.query.charAt(n);
            if (n3 == 0) {
                if (c == '\'' || c == '\"') {
                    n3 = c;
                } else if (c == '{') {
                    stringBuffer2 = new StringBuffer();
                    n3 = 125;
                }
            } else if (n3 != 0 && !bl) {
                if (c == '\\') {
                    bl = true;
                } else {
                    bl = false;
                    if (c == (char)n3) {
                        n3 = 0;
                        if (c == '}') {
                            stringBuffer2.append('}');
                            stringBuffer.append(this.escapeJDBCSubstitution(new String(stringBuffer2)));
                            stringBuffer2 = null;
                            c = ' ';
                        }
                    }
                }
            }
            if (n3 != 125) {
                stringBuffer.append(c);
            } else {
                stringBuffer2.append(c);
            }
            ++n;
        }
        if (n3 == 125) {
            throw new SQLException("Unterminated JDBC escape code in query: " + new String(stringBuffer2));
        }
        this.query = new String(stringBuffer);
    }

    public void prepare(boolean bl) throws SQLException {
        if (bl) {
            this.doEscapeSubstitutions();
        }
        this.prepared = true;
    }

    public boolean equals(Object object) {
        SQLQuery sQLQuery = (SQLQuery)object;
        if (this.query.equals(sQLQuery.query) && this.parameter_count == sQLQuery.parameter_count) {
            int n = 0;
            while (n < this.parameter_count) {
                if (this.parameters[n] != sQLQuery.parameters[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ Query:\n[ ");
        stringBuffer.append(this.getQuery());
        stringBuffer.append(" ]\n");
        if (this.parameter_count > 0) {
            stringBuffer.append("\nParams:\n[ ");
            int n = 0;
            while (n < this.parameter_count) {
                Object object = this.parameters[n];
                if (object == null) {
                    stringBuffer.append("NULL");
                } else {
                    stringBuffer.append(this.parameters[n].toString());
                }
                stringBuffer.append(", ");
                ++n;
            }
            stringBuffer.append(" ]");
        }
        stringBuffer.append("\n]");
        return new String(stringBuffer);
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.query);
        dataOutputStream.writeInt(this.parameter_count);
        int n = 0;
        while (n < this.parameter_count) {
            ObjectTransfer.writeTo(dataOutputStream, this.parameters[n]);
            ++n;
        }
    }

    public static SQLQuery readFrom(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        SQLQuery sQLQuery = new SQLQuery(string);
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            sQLQuery.addVar(ObjectTransfer.readFrom(dataInputStream));
            ++n2;
        }
        return sQLQuery;
    }
}

