/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.RemoteDatabaseInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class StreamDatabaseInterface
extends RemoteDatabaseInterface {
    protected DataOutputStream out;
    protected DataInputStream in;
    private boolean closed = false;

    StreamDatabaseInterface() {
    }

    void setup(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new IOException("rawin or rawin is null");
        }
        this.in = new DataInputStream(new BufferedInputStream(inputStream, 32768));
        this.out = new DataOutputStream(new BufferedOutputStream(outputStream, 32768));
    }

    void writeCommandToServer(byte[] byArray, int n, int n2) throws IOException {
        this.out.writeInt(n2);
        this.out.write(byArray, 0, n2);
        this.out.flush();
    }

    byte[] nextCommandFromServer(int n) throws IOException {
        if (this.closed) {
            throw new IOException("DatabaseInterface is closed!");
        }
        try {
            int n2 = this.in.readInt();
            byte[] byArray = new byte[n2];
            this.in.readFully(byArray, 0, n2);
            return byArray;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Throwable generated at: " + this);
            throw nullPointerException;
        }
    }

    void closeConnection() throws IOException {
        this.closed = true;
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            this.in.close();
            throw iOException;
        }
        this.in.close();
    }
}

