/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.debug.Debug;

public class Cache {
    private int max_cache_size;
    private int current_cache_size;
    private int wipe_to;
    private final ListNode[] node_hash;
    private ListNode list_start;
    private ListNode list_end;
    private long total_gets = 0L;
    private long get_total = 0L;

    public Cache(int n, int n2, int n3) {
        if (n3 >= 85) {
            throw new RuntimeException("Can't set to wipe more than 85% of the cache during clean.");
        }
        this.max_cache_size = n2;
        this.current_cache_size = 0;
        this.wipe_to = n2 - n3 * n2 / 100;
        this.node_hash = new ListNode[n];
        this.list_start = null;
        this.list_end = null;
    }

    public Cache(int n, int n2) {
        this(n * 2 + 1, n, 20);
    }

    public Cache(int n) {
        this(n, 20);
    }

    public Cache() {
        this(50);
    }

    protected final int getHashSize() {
        return this.max_cache_size * 2 + 1;
    }

    protected void checkClean() {
        if (this.current_cache_size >= this.max_cache_size) {
            this.clean();
        }
    }

    protected boolean shouldWipeMoreNodes() {
        return this.current_cache_size >= this.wipe_to;
    }

    protected void notifyWipingNode(Object object) {
    }

    protected void notifyGetWalks(long l, long l2) {
    }

    private ListNode getFromHash(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.node_hash.length;
        int n3 = 1;
        ListNode listNode = this.node_hash[n2];
        while (listNode != null) {
            if (object.equals(listNode.key)) {
                ++this.total_gets;
                this.get_total += (long)n3;
                if ((this.total_gets & 0x1FFFL) == 0L) {
                    try {
                        this.notifyGetWalks(this.get_total, this.total_gets);
                        if (this.get_total > 0L) {
                            this.get_total = 0L;
                            this.total_gets = 0L;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (n3 > 1) {
                    this.bringToHead(listNode);
                }
                return listNode;
            }
            ++n3;
            listNode = listNode.next_hash_entry;
        }
        return null;
    }

    private ListNode putIntoHash(ListNode listNode) {
        int n = listNode.key.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.node_hash.length;
        Object object = listNode.key;
        ListNode listNode2 = this.node_hash[n2];
        while (listNode2 != null) {
            if (object.equals(listNode2.key)) {
                throw new Error("ListNode with same key already in the hash - remove first.");
            }
            listNode2 = listNode2.next_hash_entry;
        }
        listNode.next_hash_entry = this.node_hash[n2];
        this.node_hash[n2] = listNode;
        return listNode;
    }

    private ListNode removeFromHash(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.node_hash.length;
        ListNode listNode = null;
        ListNode listNode2 = this.node_hash[n2];
        while (listNode2 != null) {
            if (object.equals(listNode2.key)) {
                if (listNode == null) {
                    this.node_hash[n2] = listNode2.next_hash_entry;
                } else {
                    listNode.next_hash_entry = listNode2.next_hash_entry;
                }
                return listNode2;
            }
            listNode = listNode2;
            listNode2 = listNode2.next_hash_entry;
        }
        return null;
    }

    private void clearHash() {
        int n = this.node_hash.length - 1;
        while (n >= 0) {
            this.node_hash[n] = null;
            --n;
        }
    }

    public final int nodeCount() {
        return this.current_cache_size;
    }

    public final void put(Object object, Object object2) {
        this.checkClean();
        ListNode listNode = this.getFromHash(object);
        if (listNode == null) {
            listNode = this.createListNode();
            listNode.key = object;
            listNode.contents = object2;
            listNode.next = this.list_start;
            listNode.previous = null;
            this.list_start = listNode;
            if (listNode.next == null) {
                this.list_end = listNode;
            } else {
                listNode.next.previous = listNode;
            }
            ++this.current_cache_size;
            this.putIntoHash(listNode);
        } else {
            listNode.contents = object2;
            this.bringToHead(listNode);
        }
    }

    public final Object get(Object object) {
        ListNode listNode = this.getFromHash(object);
        if (listNode != null) {
            return listNode.contents;
        }
        return null;
    }

    public final Object remove(Object object) {
        ListNode listNode = this.removeFromHash(object);
        if (listNode != null) {
            if (this.list_start == listNode) {
                this.list_start = listNode.next;
                if (this.list_start != null) {
                    this.list_start.previous = null;
                } else {
                    this.list_end = null;
                }
            } else if (this.list_end == listNode) {
                this.list_end = listNode.previous;
                if (this.list_end != null) {
                    this.list_end.next = null;
                } else {
                    this.list_start = null;
                }
            } else {
                listNode.previous.next = listNode.next;
                listNode.next.previous = listNode.previous;
            }
            --this.current_cache_size;
            Object object2 = listNode.contents;
            listNode.contents = null;
            listNode.key = null;
            return object2;
        }
        return null;
    }

    public void removeAll() {
        if (this.current_cache_size != 0) {
            this.current_cache_size = 0;
            this.clearHash();
        }
        this.list_start = null;
        this.list_end = null;
    }

    public void clear() {
        this.removeAll();
    }

    private final ListNode createListNode() {
        return new ListNode();
    }

    protected final int clean() {
        ListNode listNode = this.list_end;
        if (listNode == null) {
            Debug.write(20, this, "WARNING: No elements to clean!");
            return 0;
        }
        int n = 0;
        while (listNode != null && this.shouldWipeMoreNodes()) {
            this.notifyWipingNode(listNode.contents);
            this.removeFromHash(listNode.key);
            listNode.contents = null;
            listNode.key = null;
            ListNode listNode2 = listNode;
            listNode = listNode.previous;
            listNode2.next = null;
            listNode2.previous = null;
            --this.current_cache_size;
            ++n;
        }
        if (listNode != null) {
            listNode.next = null;
            this.list_end = listNode;
        } else {
            this.list_start = null;
            this.list_end = null;
        }
        return n;
    }

    private final void bringToHead(ListNode listNode) {
        if (this.list_start != listNode) {
            ListNode listNode2 = listNode.next;
            ListNode listNode3 = listNode.previous;
            listNode.next = this.list_start;
            listNode.previous = null;
            this.list_start = listNode;
            listNode.next.previous = listNode;
            if (listNode2 != null) {
                listNode2.previous = listNode3;
            } else {
                this.list_end = listNode3;
            }
            listNode3.next = listNode2;
        }
    }

    static final class ListNode {
        ListNode next;
        ListNode previous;
        ListNode next_hash_entry;
        Object key;
        Object contents;

        ListNode() {
        }
    }
}

