/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.PropertyException;
import org.webmacro.engine.EvaluationExceptionHandler;
import org.webmacro.engine.FunctionCall;
import org.webmacro.engine.MethodWrapper;
import org.webmacro.engine.StaticClassWrapper;
import org.webmacro.engine.UndefinedMacro;

public class Context
implements Map,
Cloneable {
    private final Broker _broker;
    private final Log _log;
    private HashMap _funcs = null;
    private EvaluationExceptionHandler _eeHandler;
    private Map _variables = new HashMap();
    private TemplateEvaluationContext _teContext = new TemplateEvaluationContext();
    private static final UndefinedMacro UNDEF = UndefinedMacro.getInstance();

    public Context() throws InitException {
        this(Broker.getBroker());
    }

    public Context(Broker broker) {
        this._broker = broker;
        this._log = broker.getLog("context", "property and evaluation errors");
    }

    public final Object clone() {
        return this.cloneContext();
    }

    public Context cloneContext() {
        Context c;
        try {
            c = (Context)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        c._teContext = new TemplateEvaluationContext();
        c._variables = this._variables instanceof HashMap ? (Map)((HashMap)this._variables).clone() : new HashMap(this._variables);
        return c;
    }

    public void clear() {
        this._variables.clear();
        this._eeHandler = null;
    }

    public final Broker getBroker() {
        return this._broker;
    }

    public final TemplateEvaluationContext getTemplateEvaluationContext() {
        return this._teContext;
    }

    public final String getCurrentLocation() {
        StringBuffer loc = new StringBuffer();
        loc.append(this._teContext._templateName == null ? "(unknown)" : this._teContext._templateName);
        loc.append(":").append(this._teContext._lineNo).append(".").append(this._teContext._columnNo);
        return loc.toString();
    }

    public final Log getLog(String type, String description) {
        return this._broker.getLog(type, description);
    }

    public final Log getLog(String type) {
        return this._broker.getLog(type, type);
    }

    public EvaluationExceptionHandler getEvaluationExceptionHandler() {
        if (this._eeHandler != null) {
            return this._eeHandler;
        }
        return this._broker.getEvaluationExceptionHandler();
    }

    public void setEvaluationExceptionHandler(EvaluationExceptionHandler eeh) {
        this._eeHandler = eeh;
    }

    protected Object internalGet(Object name) throws PropertyException {
        Object ret = this._variables.get(name);
        if (ret != null || this._variables.containsKey(name)) {
            return ret;
        }
        if (name instanceof String) {
            Object var = this._broker.getAutoContextVariable((String)name, this);
            if (var != null) {
                this.put(name, var);
                return var;
            }
            return UNDEF;
        }
        if (name instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)name;
            String fname = fc.getName();
            MethodWrapper func = null;
            if (this._funcs != null) {
                func = (MethodWrapper)this._funcs.get(fname);
            }
            if (func == null) {
                func = this._broker.getFunction(fname);
            }
            if (func != null) {
                Object[] args = fc.getArguments(this);
                ret = func.invoke(args);
            } else {
                this._log.error("Function " + fname + " was not loaded!");
            }
            return ret;
        }
        return UNDEF;
    }

    public final Object get(Object name) {
        try {
            Object o = this.internalGet(name);
            if (o == UNDEF) {
                return null;
            }
            return o;
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public final Object put(Object name, Class c) {
        if (c == null) {
            return this._variables.put(name, null);
        }
        return this._variables.put(name, new StaticClassWrapper(c));
    }

    public final void putFunction(String name, Object instance, String methodName) {
        MethodWrapper func = this.wrapMethod(instance, methodName);
        if (this._funcs == null) {
            this._funcs = new HashMap();
        }
        this._funcs.put(name, func);
    }

    public final void putGlobalFunction(String name, Object instance, String methodName) {
        MethodWrapper func = this.wrapMethod(instance, methodName);
        this._broker.putFunction(name, func);
    }

    private final MethodWrapper wrapMethod(Object instance, String methodName) {
        MethodWrapper func = null;
        try {
            func = new MethodWrapper(instance, methodName);
        }
        catch (Exception e) {
            String className = null;
            if (instance instanceof Class) {
                className = ((Class)instance).getName();
            } else if (instance != null) {
                className = instance.getClass().getName();
            }
            this._log.error("Unable to construct function from method: " + methodName + " of class " + className);
        }
        return func;
    }

    public final Object put(Object name, Object value) {
        return this._variables.put(name, value);
    }

    protected Object internalGet(Object[] names) throws PropertyException {
        Object instance;
        try {
            instance = this.internalGet(names[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PropertyException("Attempt to access property with a zero length name array");
        }
        if (names.length == 1) {
            return instance;
        }
        if (instance == null) {
            throw new PropertyException.NullValueException(names[0].toString());
        }
        return this._broker._propertyOperators.getProperty(this, instance, names, 1);
    }

    public final boolean set(Object[] names, Object value) throws PropertyException {
        Object instance;
        if (names.length == 1) {
            this.put(names[0], value);
            return true;
        }
        try {
            instance = this.internalGet(names[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return this._broker._propertyOperators.setProperty(this, instance, names, 1, value);
    }

    public Object getProperty(Object name) throws PropertyException {
        return this.internalGet(name);
    }

    public boolean setProperty(Object name, Object value) throws PropertyException {
        this.put(name, value);
        return true;
    }

    public Object getProperty(Object[] names) throws PropertyException {
        return this.internalGet(names);
    }

    public boolean setProperty(Object[] names, Object value) throws PropertyException {
        return this.set(names, value);
    }

    public final void setMap(Map m) {
        this._variables = m;
    }

    public final Map getMap() {
        return this._variables;
    }

    public boolean containsKey(Object key) {
        return this._variables.containsKey(key);
    }

    public final boolean containsValue(Object value) {
        return this._variables.containsValue(value);
    }

    public final Set entrySet() {
        return this._variables.entrySet();
    }

    public final boolean isEmpty() {
        return this._variables.isEmpty();
    }

    public final Set keySet() {
        return this._variables.keySet();
    }

    public final void putAll(Map t) {
        this._variables.putAll(t);
    }

    public final Object remove(Object key) {
        return this._variables.remove(key);
    }

    public final int size() {
        return this._variables.size();
    }

    public final Collection values() {
        return this._variables.values();
    }

    public String toString() {
        return this._variables.toString();
    }

    public final void put(Object o, int i) {
        this.put(o, new Integer(i));
    }

    public final void put(Object o, byte b) {
        this.put(o, new Byte(b));
    }

    public final void put(Object o, short s) {
        this.put(o, new Short(s));
    }

    public final void put(Object o, long l) {
        this.put(o, new Long(l));
    }

    public final void put(Object o, char c) {
        this.put(o, new Character(c));
    }

    public final void put(Object o, float f) {
        this.put(o, new Float(f));
    }

    public final void put(Object o, double d) {
        this.put(o, new Double(d));
    }

    public final void put(Object o, boolean b) {
        this.put(o, new Boolean(b));
    }

    public static final class TemplateEvaluationContext {
        public String _templateName;
        public int _lineNo;
        public int _columnNo;
    }
}

