/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.adapter.jsp;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.webmacro.InitException;
import org.webmacro.PropertyException;
import org.webmacro.Template;
import org.webmacro.WM;
import org.webmacro.WebMacro;
import org.webmacro.adapter.jsp.JSPAttributes;
import org.webmacro.engine.StringTemplate;
import org.webmacro.servlet.WebContext;

public class TemplateTag
extends BodyTagSupport {
    private static final long serialVersionUID = -6790150900989142583L;
    private static final int DEFAULT_TEMPLATE_BUFFER_SIZE = 4000;
    private static final String TEMPORARY_ENCODING = "UTF-8";
    private static final String ATTRIBUTES_HELPER_NAME = "Attributes";
    private static final String CONTEXT_VARIABLE_NAME = "Context";
    private WebMacro webmacro;
    private Object context;
    private String src;
    private boolean propertyErrorsFailFast = true;

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public WebMacro getWebMacro() throws InitException {
        if (this.webmacro == null) {
            this.webmacro = this.makeWM();
        }
        return this.webmacro;
    }

    private WebMacro makeWM() throws InitException {
        ClassLoader classLoader = this.pageContext.getPage().getClass().getClassLoader();
        return new WM(this.pageContext.getServletContext(), classLoader, null);
    }

    public int doStartTag() throws JspException {
        if (this.src != null) {
            this.doEval();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.src == null) {
            this.doEval();
        }
        return 6;
    }

    private void doEval() throws JspTagException {
        String servletName = this.pageContext.getServletConfig().getServletName();
        try {
            BodyContent bodyContent = this.getBodyContent();
            JspWriter writer = this.pageContext.getOut();
            if (bodyContent != null) {
                writer = bodyContent.getEnclosingWriter();
            }
            WebContext webContext = this.getWebMacro().getWebContext((HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse());
            if (this.context != null) {
                if (this.context instanceof Map) {
                    webContext.putAll((Map)this.context);
                } else {
                    webContext.put((Object)CONTEXT_VARIABLE_NAME, this.context);
                }
            }
            webContext.put((Object)ATTRIBUTES_HELPER_NAME, new JSPAttributes(this.pageContext));
            Template templ = null;
            String templateOutput = null;
            try {
                if (this.src != null) {
                    templ = this.webmacro.getTemplate(this.src);
                } else if (bodyContent != null) {
                    templ = new StringTemplate(this.webmacro.getBroker(), bodyContent.getString(), "WebMacro script in JSP page " + servletName);
                }
                if (templ != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(4000);
                    templ.write(baos, TEMPORARY_ENCODING, webContext);
                    templateOutput = baos.toString(TEMPORARY_ENCODING);
                    baos = null;
                }
            }
            catch (PropertyException e) {
                if (!this.propertyErrorsFailFast) {
                    templateOutput = "WebMacro property access error occurred: " + e;
                }
                throw e;
            }
            writer.print(templateOutput);
            if (bodyContent != null) {
                bodyContent.clearBody();
            }
        }
        catch (Exception e) {
            throw new JspTagException("WM Template tag error: " + e);
        }
    }

    public void release() {
        this.src = null;
        this.context = null;
        this.propertyErrorsFailFast = true;
    }

    public boolean isFailFast() {
        return this.propertyErrorsFailFast;
    }

    public void setFailFast(boolean failFast) {
        this.propertyErrorsFailFast = failFast;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }
}

