/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.Log;
import org.webmacro.PropertyException;
import org.webmacro.broker.ContextAutoLoader;
import org.webmacro.broker.ContextObjectFactory;
import org.webmacro.util.Settings;

public class DefaultContextAutoLoader
implements ContextAutoLoader {
    private Log _log;
    private Broker _broker;
    private Map _factories = new ConcurrentHashMap();
    static /* synthetic */ Class class$java$lang$String;

    public void init(Broker b, String name) {
        this._broker = b;
        this._log = b.getLog("broker");
        this.loadFactories(name);
    }

    public Object get(String name, Context context) throws PropertyException {
        Object o = this._factories.get(name);
        if (o == null) {
            return null;
        }
        ContextObjectFactory f = (ContextObjectFactory)o;
        return f.get(context);
    }

    private void loadFactories(String keyName) {
        this._broker.getSettings().processListSetting(keyName, new AutoContextSettingsHandler());
    }

    private void addAutoVariable(String toolName, String className) {
        Class c;
        try {
            c = this._broker.classForName(className);
        }
        catch (ClassNotFoundException e) {
            this._log.warning("Context: Could not locate class for context tool " + className);
            return;
        }
        if (toolName == null || toolName.equals("")) {
            toolName = className;
            int start = 0;
            int end = toolName.length();
            int lastDot = toolName.lastIndexOf(46);
            if (lastDot != -1) {
                start = lastDot + 1;
            }
            toolName = toolName.substring(start, end);
        }
        Constructor<?> ctor = null;
        Constructor<?>[] ctors = c.getConstructors();
        Class<?>[] parmTypes = null;
        Object instance = null;
        for (int i = 0; i < ctors.length; ++i) {
            parmTypes = ctors[i].getParameterTypes();
            if (parmTypes.length != 1 || !parmTypes[0].equals(class$java$lang$String == null ? DefaultContextAutoLoader.class$("java.lang.String") : class$java$lang$String)) continue;
            ctor = ctors[i];
            Object[] args = new Object[]{toolName};
            try {
                instance = ctor.newInstance(args);
                continue;
            }
            catch (Exception e) {
                this._log.error("Failed to instantiate tool " + toolName + " of class " + className + " using constructor " + ctor.toString(), e);
            }
        }
        if (instance == null) {
            try {
                instance = c.newInstance();
            }
            catch (Exception e) {
                this._log.error("Unable to construct tool " + toolName + " of class " + className, e);
                return;
            }
        }
        if (instance instanceof ContextObjectFactory) {
            this._factories.put(toolName, instance);
            this._broker.registerAutoContextVariable(toolName, this);
            this._log.info("Registered automatic variable factory " + toolName);
        } else {
            this._log.warning("Context object " + toolName + " is not of type ContextObjectFactory");
        }
    }

    private class AutoContextSettingsHandler
    extends Settings.ListSettingHandler {
        private AutoContextSettingsHandler() {
        }

        public void processSetting(String settingKey, String settingValue) {
            try {
                DefaultContextAutoLoader.this.addAutoVariable(settingKey, settingValue);
            }
            catch (Exception e) {
                DefaultContextAutoLoader.this._log.error("Automatic variable (" + settingValue + ") failed to load", e);
            }
        }
    }
}

